/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.shared;

import com.lightstep.tracer.grpc.KeyValue;
import com.lightstep.tracer.grpc.Log;
import com.lightstep.tracer.grpc.Span;
import com.lightstep.tracer.shared.AbstractTracer;
import com.lightstep.tracer.shared.SpanContext;
import com.lightstep.tracer.shared.Util;
import io.opentracing.tag.Tag;
import java.util.HashMap;
import java.util.Map;

public class Span
implements io.opentracing.Span {
    static final String LOG_KEY_EVENT = "event";
    static final String LOG_KEY_MESSAGE = "message";
    private final Object mutex = new Object();
    private final AbstractTracer tracer;
    private final long startTimestampRelativeNanos;
    private final Span.Builder grpcSpan;
    private SpanContext context;

    Span(AbstractTracer tracer, SpanContext context, Span.Builder grpcSpan, long startTimestampRelativeNanos) {
        this.context = context;
        this.tracer = tracer;
        this.grpcSpan = grpcSpan;
        this.startTimestampRelativeNanos = startTimestampRelativeNanos;
        if (tracer != null && tracer.metaEventLoggingEnabled && Util.IsNotMetaSpan(this)) {
            tracer.buildSpan("lightstep.span_start").ignoreActiveSpan().withTag("lightstep.meta_event", true).withTag("lightstep.span_id", (Number)context.getSpanId()).withTag("lightstep.trace_id", (Number)context.getTraceId()).start().finish();
        }
    }

    public SpanContext context() {
        return this.context;
    }

    public void finish() {
        this.finish(this.nowMicros());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(long finishTimeMicros) {
        if (this.tracer.metaEventLoggingEnabled && Util.IsNotMetaSpan(this)) {
            this.tracer.buildSpan("lightstep.span_finish").ignoreActiveSpan().withTag("lightstep.meta_event", true).withTag("lightstep.span_id", (Number)this.context.getSpanId()).withTag("lightstep.trace_id", (Number)this.context.getTraceId()).start().finish();
        }
        Object object = this.mutex;
        synchronized (object) {
            this.grpcSpan.setDurationMicros(this.durationMicros(finishTimeMicros));
            this.tracer.addSpan(this.grpcSpan.build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Span setTag(String key, String value) {
        if (key == null || value == null) {
            this.tracer.debug("key (" + key + ") or value (" + value + ") is null, ignoring");
            return this;
        }
        Object object = this.mutex;
        synchronized (object) {
            this.grpcSpan.addTags(KeyValue.newBuilder().setKey(key).setStringValue(value));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Span setTag(String key, boolean value) {
        if (key == null) {
            this.tracer.debug("key is null, ignoring");
            return this;
        }
        Object object = this.mutex;
        synchronized (object) {
            this.grpcSpan.addTags(KeyValue.newBuilder().setKey(key).setBoolValue(value));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Span setTag(String key, Number value) {
        if (key == null || value == null) {
            this.tracer.debug("key (" + key + ") or value (" + value + ") is null, ignoring");
            return this;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (value instanceof Long || value instanceof Integer) {
                this.grpcSpan.addTags(KeyValue.newBuilder().setKey(key).setIntValue(value.longValue()));
            } else if (value instanceof Double || value instanceof Float) {
                this.grpcSpan.addTags(KeyValue.newBuilder().setKey(key).setDoubleValue(value.doubleValue()));
            } else {
                this.grpcSpan.addTags(KeyValue.newBuilder().setKey(key).setStringValue(value.toString()));
            }
        }
        return this;
    }

    public <T> Span setTag(Tag<T> tag, T value) {
        if (tag == null || value == null) {
            this.tracer.debug("tag (" + tag + ") or value (" + value + ") is null, ignoring");
            return this;
        }
        tag.set((io.opentracing.Span)this, value);
        return this;
    }

    public synchronized String getBaggageItem(String key) {
        return this.context.getBaggageItem(key);
    }

    public synchronized Span setBaggageItem(String key, String value) {
        this.context = this.context.withBaggageItem(key, value);
        return this;
    }

    public synchronized Span setOperationName(String operationName) {
        this.grpcSpan.setOperationName(operationName);
        return this;
    }

    public Span setComponentName(String componentName) {
        if (componentName == null) {
            this.tracer.debug("componentName is null, ignoring");
            return this;
        }
        return this.setTag("lightstep.component_name", componentName);
    }

    public void close() {
        this.finish();
    }

    public AbstractTracer getTracer() {
        return this.tracer;
    }

    public final Span log(Map<String, ?> fields) {
        return this.log(this.nowMicros(), (Map)fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Span log(long timestampMicros, Map<String, ?> fields) {
        Log.Builder log = Log.newBuilder().setTimestamp(Util.epochTimeMicrosToProtoTime(timestampMicros));
        for (Map.Entry<String, ?> kv : fields.entrySet()) {
            String key = kv.getKey();
            Object value = kv.getValue();
            if (key == null) continue;
            if (value == null) {
                value = "";
            }
            KeyValue.Builder outKV = KeyValue.newBuilder().setKey(key);
            Object inValue = value;
            if (inValue instanceof String) {
                outKV.setStringValue((String)inValue);
            } else if (inValue instanceof Number) {
                if (inValue instanceof Long || inValue instanceof Integer) {
                    outKV.setIntValue(((Number)inValue).longValue());
                } else if (inValue instanceof Double || inValue instanceof Float) {
                    outKV.setDoubleValue(((Number)inValue).doubleValue());
                } else {
                    outKV.setStringValue(inValue.toString());
                }
            } else if (inValue instanceof Boolean) {
                outKV.setBoolValue((Boolean)inValue);
            } else {
                outKV.setJsonValue(Span.stringToJSONValue(inValue.toString()));
            }
            log.addFields(outKV.build());
        }
        Object object = this.mutex;
        synchronized (object) {
            this.grpcSpan.addLogs(log.build());
        }
        return this;
    }

    public Span log(String message) {
        return this.log(this.nowMicros(), message, null);
    }

    public Span log(long timestampMicroseconds, String message) {
        return this.log(timestampMicroseconds, message, null);
    }

    private Span log(long timestampMicroseconds, String message, Object payload) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put(LOG_KEY_MESSAGE, message);
        if (payload != null) {
            fields.put("payload", payload);
        }
        return this.log(timestampMicroseconds, fields);
    }

    public String generateTraceURL() {
        return this.tracer.generateTraceURL(this.context.getSpanId());
    }

    private long nowMicros() {
        if (this.startTimestampRelativeNanos > 0L) {
            long durationMicros = (System.nanoTime() - this.startTimestampRelativeNanos) / 1000L;
            return Util.protoTimeToEpochMicros(this.grpcSpan.getStartTimestamp()) + durationMicros;
        }
        return System.currentTimeMillis() * 1000L;
    }

    private long durationMicros(long finishTimeMicros) {
        return finishTimeMicros - Util.protoTimeToEpochMicros(this.grpcSpan.getStartTimestamp());
    }

    static String stringToJSONValue(String value) {
        StringBuilder out = new StringBuilder(value.length() + 2);
        out.append("\"");
        int length = value.length();
        block8: for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\"': 
                case '/': 
                case '\\': {
                    out.append('\\').append(c);
                    continue block8;
                }
                case '\t': {
                    out.append("\\t");
                    continue block8;
                }
                case '\b': {
                    out.append("\\b");
                    continue block8;
                }
                case '\n': {
                    out.append("\\n");
                    continue block8;
                }
                case '\r': {
                    out.append("\\r");
                    continue block8;
                }
                case '\f': {
                    out.append("\\f");
                    continue block8;
                }
                default: {
                    if (c <= '\u001f') {
                        out.append(String.format("\\u%04x", c));
                        continue block8;
                    }
                    out.append(c);
                }
            }
        }
        out.append("\"");
        return out.toString();
    }

    long getStartTimestampRelativeNanos() {
        return this.startTimestampRelativeNanos;
    }

    public Span.Builder getGrpcSpan() {
        return this.grpcSpan;
    }
}

