/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.shared;

import com.lightstep.tracer.shared.Util;
import java.util.HashMap;
import java.util.Map;

public class SpanContext
implements io.opentracing.SpanContext {
    private final long traceId;
    private final long spanId;
    private final Map<String, String> baggage;
    private final String foreignTraceId;
    private final String[] toIds = new String[]{"", ""};
    private static final int TRACE_INDEX = 0;
    private static final int SPAN_INDEX = 1;

    public SpanContext() {
        this(Util.generateRandomGUID(), Util.generateRandomGUID());
    }

    public SpanContext(long traceId, long spanId) {
        this(traceId, spanId, null, null);
    }

    SpanContext(long traceId) {
        this(traceId, Util.generateRandomGUID());
    }

    SpanContext(long traceId, Map<String, String> baggage) {
        this((Long)traceId, (Long)Util.generateRandomGUID(), baggage);
    }

    SpanContext(Long traceId, Long spanId, Map<String, String> baggage) {
        this(traceId, spanId, baggage, null);
    }

    SpanContext(Long traceId, Long spanId, String foreignTraceId) {
        this(traceId, spanId, null, foreignTraceId);
    }

    SpanContext(Long traceId, Long spanId, Map<String, String> baggage, String foreignTraceId) {
        if (traceId == null) {
            traceId = Util.generateRandomGUID();
        }
        if (spanId == null) {
            spanId = Util.generateRandomGUID();
        }
        if (baggage == null) {
            baggage = new HashMap<String, String>();
        }
        this.traceId = traceId;
        this.spanId = spanId;
        this.baggage = baggage;
        this.foreignTraceId = foreignTraceId;
        this.toIds[0] = Util.toHexString(traceId);
        this.toIds[1] = Util.toHexString(spanId);
    }

    public long getSpanId() {
        return this.spanId;
    }

    public long getTraceId() {
        return this.traceId;
    }

    public String getForeignTraceId() {
        return this.foreignTraceId;
    }

    public String toTraceId() {
        return this.toIds[0];
    }

    public String toSpanId() {
        return this.toIds[1];
    }

    String getBaggageItem(String key) {
        return this.baggage.get(key);
    }

    Map<String, String> getBaggage() {
        return this.baggage;
    }

    SpanContext withBaggageItem(String key, String value) {
        this.baggage.put(key, value);
        return new SpanContext(this.getTraceId(), this.getSpanId(), this.baggage, this.foreignTraceId);
    }

    public Iterable<Map.Entry<String, String>> baggageItems() {
        return this.baggage.entrySet();
    }

    public com.lightstep.tracer.grpc.SpanContext getInnerSpanCtx() {
        return com.lightstep.tracer.grpc.SpanContext.newBuilder().setTraceId(this.getTraceId()).setSpanId(this.getSpanId()).putAllBaggage(this.baggage).build();
    }
}

