/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.shared;

import com.google.protobuf.Timestamp;
import com.lightstep.tracer.grpc.KeyValue;
import com.lightstep.tracer.shared.Span;
import java.math.BigInteger;
import java.util.Random;

class Util {
    private static ThreadLocal<Random> random = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new Random(System.currentTimeMillis() * (System.nanoTime() % 1000000L) * Thread.currentThread().getId() * (long)(1024.0 * Math.random()));
        }
    };

    Util() {
    }

    static long generateRandomGUID() {
        return random.get().nextLong();
    }

    static long protoTimeToEpochMicros(Timestamp timestamp) {
        return timestamp.getSeconds() * 1000000L + (long)(timestamp.getNanos() / 1000);
    }

    static Timestamp epochTimeMicrosToProtoTime(long micros) {
        Timestamp.Builder builder = Timestamp.newBuilder();
        builder.setSeconds(micros / 1000000L);
        builder.setNanos((int)(micros % 1000000L) * 1000);
        return builder.build();
    }

    static long nowMicrosApproximate() {
        return System.currentTimeMillis() * 1000L;
    }

    static Long fromHexString(String hexString) {
        if (hexString == null || hexString.length() == 0) {
            return null;
        }
        Long value = null;
        try {
            value = new BigInteger(hexString, 16).longValue();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }

    static String toHexString(long l) {
        return Long.toHexString(l);
    }

    static boolean IsNotMetaSpan(Span span) {
        if (span == null) {
            return true;
        }
        KeyValue kvp = KeyValue.newBuilder().setKey("lightstep.meta_event").setBoolValue(true).build();
        return !span.getGrpcSpan().getTagsList().contains(kvp);
    }
}

