/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.metrics;

import com.lightstep.tracer.metrics.CounterMetric;
import com.lightstep.tracer.metrics.MetricGroup;
import com.lightstep.tracer.metrics.Sender;
import java.io.IOException;
import oshi.hardware.CentralProcessor;
import oshi.hardware.HardwareAbstractionLayer;

class CpuMetricGroup
extends MetricGroup {
    private static final CounterMetric<CpuMetricGroup, Long> cpuUsage = new CounterMetric("cpu.usage", Long.class, 1000L);
    private static final CounterMetric<CpuMetricGroup, Long> cpuTotal = new CounterMetric("cpu.total", Long.class, 1000L);

    private static long sum(long[] ticks) {
        long total = 0L;
        for (int i = 0; i < ticks.length; ++i) {
            total += ticks[i];
        }
        return total;
    }

    CpuMetricGroup(HardwareAbstractionLayer hal) {
        super(hal, new CounterMetric("cpu.user", Long.class, 1000L), null, new CounterMetric("cpu.sys", Long.class, 1000L), null, null, null, null, null);
    }

    @Override
    <I, O> long[] newSample() throws IOException {
        return this.hal.getProcessor().getSystemCpuLoadTicks();
    }

    @Override
    <I, O> long[] execute(Sender<I, O> sender, I request, long timestampSeconds, long durationSeconds) throws IOException {
        long[] previous = this.getPrevious();
        long previousTotal = CpuMetricGroup.sum(previous);
        long previousUsage = previousTotal - previous[CentralProcessor.TickType.IDLE.getIndex()];
        long[] current = super.execute(sender, request, timestampSeconds, durationSeconds);
        long currentTotal = CpuMetricGroup.sum(current);
        long currentUsage = currentTotal - current[CentralProcessor.TickType.IDLE.getIndex()];
        if (logger.isDebugEnabled()) {
            logger.debug("'-- " + cpuUsage.getName() + "[" + (currentUsage - previousUsage) + "]");
            logger.debug("'-- " + cpuTotal.getName() + "[" + (currentTotal - previousTotal) + "]");
        }
        sender.createMessage(request, timestampSeconds, durationSeconds, cpuTotal, currentTotal, previousTotal);
        sender.createMessage(request, timestampSeconds, durationSeconds, cpuUsage, currentUsage, previousUsage);
        return current;
    }
}

