/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.metrics;

import com.lightstep.tracer.metrics.CounterMetric;
import com.lightstep.tracer.metrics.GaugeMetric;
import com.lightstep.tracer.metrics.MetricGroup;
import java.io.IOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import oshi.hardware.HardwareAbstractionLayer;

class GcMetricGroup
extends MetricGroup {
    GcMetricGroup(HardwareAbstractionLayer hal) {
        super(hal, new GaugeMetric("runtime.java.heap_size", Long.class, 1L), new CounterMetric("runtime.java.gc.count", Long.class, 1L), new CounterMetric("runtime.java.gc.time", Long.class, 1000L));
    }

    @Override
    <I, O> long[] newSample() throws IOException {
        long totalCount = 0L;
        long totalTime = 0L;
        for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
            long time;
            long count = bean.getCollectionCount();
            if (count > 0L) {
                totalCount += count;
            }
            if ((time = bean.getCollectionTime()) <= 0L) continue;
            totalTime += time;
        }
        long heapSize = Runtime.getRuntime().totalMemory();
        return new long[]{heapSize, totalCount, totalTime};
    }
}

