/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.metrics;

import com.lightstep.tracer.metrics.MetricGroup;
import com.lightstep.tracer.metrics.ValueAdapter;
import java.util.Objects;

abstract class Metric<G extends MetricGroup, V extends Number> {
    private final ValueAdapter<V> adapter;
    private final String name;
    private final long factor;

    Metric(String name, Class<V> type, long factor) {
        this.name = name;
        this.factor = factor;
        this.adapter = Objects.requireNonNull(ValueAdapter.get(type), type.getName());
    }

    final ValueAdapter<V> getAdapter() {
        return this.adapter;
    }

    final String getName() {
        return this.name;
    }

    abstract V compute(long var1, long var3);

    final double getValue(long current, long previous) {
        return ((Number)this.compute(current, previous)).doubleValue() / (double)this.factor;
    }
}

