/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.metrics;

import com.lightstep.tracer.metrics.CpuMetricGroup;
import com.lightstep.tracer.metrics.Metric;
import com.lightstep.tracer.metrics.Sender;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.HardwareAbstractionLayer;

abstract class MetricGroup {
    static final Logger logger = LoggerFactory.getLogger(CpuMetricGroup.class);
    final HardwareAbstractionLayer hal;
    private final Metric<? extends MetricGroup, ?>[] metrics;
    private long[] previous;

    @SafeVarargs
    MetricGroup(HardwareAbstractionLayer hal, Metric<? extends MetricGroup, ?> ... metrics) {
        this.hal = hal;
        this.metrics = metrics;
        this.previous = new long[metrics.length];
    }

    final long[] getPrevious() {
        return this.previous;
    }

    abstract <I, O> long[] newSample() throws IOException;

    <I, O> long[] execute(Sender<I, O> sender, I request, long timestampSeconds, long durationSeconds) throws IOException {
        long[] current = this.newSample();
        if (logger.isDebugEnabled()) {
            logger.debug(this.getClass().getSimpleName());
        }
        for (int i = 0; i < this.metrics.length; ++i) {
            if (this.metrics[i] == null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("'-- " + this.metrics[i].getName() + "[" + this.metrics[i].compute(current[i], this.previous[i]) + "]");
            }
            sender.createMessage(request, timestampSeconds, durationSeconds, this.metrics[i], current[i], this.previous[i]);
        }
        this.previous = current;
        return current;
    }
}

