/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.metrics;

import com.lightstep.tracer.metrics.CpuMetricGroup;
import com.lightstep.tracer.metrics.GcMetricGroup;
import com.lightstep.tracer.metrics.MemoryMetricGroup;
import com.lightstep.tracer.metrics.MetricGroup;
import com.lightstep.tracer.metrics.NetworkMetricGroup;
import com.lightstep.tracer.metrics.Sender;
import com.lightstep.tracer.retry.ExponentialBackoffRetryPolicy;
import com.lightstep.tracer.retry.RetryFailureException;
import com.lightstep.tracer.retry.RetryPolicy;
import com.lightstep.tracer.retry.Retryable;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.HardwareAbstractionLayer;

public class Metrics
extends Thread
implements Retryable<Void>,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(Metrics.class);
    private static final int attempts = Integer.MAX_VALUE;
    private static final int startDelay = 1000;
    private static final int factor = 2;
    private static final int maxDelay = Integer.MAX_VALUE;
    private static final ExponentialBackoffRetryPolicy retryPolicy = new ExponentialBackoffRetryPolicy(Integer.MAX_VALUE, 1000, 2.0, Integer.MAX_VALUE, true, 1.0){
        private static final long serialVersionUID = 7311364828386985449L;

        @Override
        protected boolean retryOn(Exception e) {
            if (logger.isDebugEnabled()) {
                logger.warn(e.getMessage(), (Throwable)e);
            } else {
                logger.warn(e.getClass().getName() + ": " + e.getMessage());
            }
            return true;
        }
    };
    private final HardwareAbstractionLayer hal = new SystemInfo().getHardware();
    private final MetricGroup[] metricGroups = new MetricGroup[]{new CpuMetricGroup(this.hal), new NetworkMetricGroup(this.hal), new MemoryMetricGroup(this.hal), new GcMetricGroup(this.hal)};
    private final int samplePeriodSeconds;
    private final Sender<?, ?> sender;
    private boolean closed;
    private long finishBy;

    public Metrics(Sender<?, ?> sender, int samplePeriodSeconds) {
        if (samplePeriodSeconds < 1) {
            throw new IllegalArgumentException("samplePeriodSeconds (" + samplePeriodSeconds + ") < 1");
        }
        this.samplePeriodSeconds = samplePeriodSeconds;
        this.sender = sender;
    }

    private static String stackTraceToString(StackTraceElement[] elements) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < elements.length; ++i) {
            if (i > 0) {
                builder.append('\n');
            }
            builder.append("  ").append(elements[i].toString());
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            Thread thread = null;
            while (!this.closed) {
                this.sender.updateSampleRequest(this.metricGroups);
                if (thread != null && thread.isAlive()) {
                    String message = "Thread should have self-terminated by now: " + (this.finishBy - System.currentTimeMillis());
                    if (logger.isDebugEnabled()) {
                        logger.warn(message + "\n" + Metrics.stackTraceToString(thread.getStackTrace()));
                    } else {
                        logger.warn(message);
                    }
                }
                thread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            Metrics.this.finishBy = (Metrics.this.sender.getPreviousTimestamp() + (long)Metrics.this.samplePeriodSeconds) * 1000L;
                            retryPolicy.run(Metrics.this, Metrics.this.finishBy - System.currentTimeMillis());
                        }
                        catch (RetryFailureException e) {
                            if (logger.isDebugEnabled()) {
                                logger.warn(e.getMessage(), (Throwable)e);
                            }
                            logger.warn(e.getClass().getName() + ": " + e.getMessage());
                        }
                    }
                };
                thread.setDaemon(true);
                thread.start();
                try {
                    Metrics.sleep(this.samplePeriodSeconds * 1000);
                }
                catch (InterruptedException e) {
                    Metrics metrics = this;
                    synchronized (metrics) {
                        this.notify();
                        return;
                    }
                    return;
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            Metrics metrics = this;
            synchronized (metrics) {
                this.notify();
            }
        }
    }

    @Override
    public Void retry(RetryPolicy retryPolicy, int attemptNo) throws Exception {
        long timeout = this.finishBy - System.currentTimeMillis();
        if (timeout <= 0L) {
            throw new RetryFailureException(attemptNo, retryPolicy.getDelayMs(attemptNo - 1));
        }
        this.sender.exec(timeout);
        return null;
    }

    @Override
    public synchronized void start() {
        if (!this.isAlive()) {
            super.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        this.closed = true;
        this.interrupt();
        this.sender.close();
        if (this.isAlive()) {
            Metrics metrics = this;
            synchronized (metrics) {
                this.wait();
            }
        }
    }
}

