/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.metrics;

import com.lightstep.tracer.metrics.CounterMetric;
import com.lightstep.tracer.metrics.MetricGroup;
import java.io.IOException;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;

class NetworkMetricGroup
extends MetricGroup {
    NetworkMetricGroup(HardwareAbstractionLayer hal) {
        super(hal, new CounterMetric("net.bytes_sent", Long.class, 1L), new CounterMetric("net.bytes_recv", Long.class, 1L));
    }

    @Override
    <I, O> long[] newSample() throws IOException {
        long[] current = new long[2];
        for (NetworkIF networkIF : this.hal.getNetworkIFs()) {
            current[0] = current[0] + networkIF.getBytesSent();
            current[1] = current[1] + networkIF.getBytesRecv();
        }
        return current;
    }
}

