/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.metrics;

import com.lightstep.tracer.grpc.IngestRequest;
import com.lightstep.tracer.grpc.IngestResponse;
import com.lightstep.tracer.metrics.ProtobufSender;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttpSender
extends ProtobufSender {
    private static final String OCTET_STREAM_TYPE = "application/octet-stream";
    private static final MediaType protoMediaType = MediaType.parse((String)"application/octet-stream");
    private static final byte[] EMPTY_BUFFER = new byte[0];
    private final AtomicReference<OkHttpClient> client;
    private final URL collectorURL;
    private final long deadlineMillis;

    public OkHttpSender(String componentName, String accessToken, String serviceVersion, String serviceUrl, int deadlineMillis, boolean sendFirstReport) {
        super(componentName, accessToken, serviceVersion, serviceUrl, sendFirstReport);
        this.deadlineMillis = deadlineMillis;
        this.client = new AtomicReference<OkHttpClient>(OkHttpSender.start(deadlineMillis));
        try {
            this.collectorURL = new URL(serviceUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    IngestResponse invoke(IngestRequest.Builder request, long timeout) throws IOException {
        Call call = this.client().newCall(new Request.Builder().url(this.collectorURL).addHeader("Accept", OCTET_STREAM_TYPE).addHeader("Content-Type", OCTET_STREAM_TYPE).addHeader("Lightstep-Access-Token", this.accessToken).post(RequestBody.create((MediaType)protoMediaType, (byte[])request.build().toByteArray())).build());
        call.timeout().deadline(timeout, TimeUnit.MILLISECONDS);
        Response response = call.execute();
        if (response.code() != 200) {
            return IngestResponse.parseFrom(EMPTY_BUFFER);
        }
        return IngestResponse.parseFrom(response.body().byteStream());
    }

    private OkHttpClient client() {
        return this.client.get();
    }

    private void reconnect() {
        this.close();
        this.client.set(OkHttpSender.start(this.deadlineMillis));
    }

    private static OkHttpClient start(long deadlineMillis) {
        return new OkHttpClient.Builder().connectTimeout(deadlineMillis, TimeUnit.MILLISECONDS).build();
    }

    @Override
    public void close() {
        OkHttpClient client = this.client();
        if (client != null) {
            client.dispatcher().executorService().shutdown();
        }
    }
}

