/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.metrics;

import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import com.lightstep.tracer.grpc.IngestRequest;
import com.lightstep.tracer.grpc.IngestResponse;
import com.lightstep.tracer.grpc.KeyValue;
import com.lightstep.tracer.grpc.MetricKind;
import com.lightstep.tracer.grpc.MetricPoint;
import com.lightstep.tracer.grpc.Reporter;
import com.lightstep.tracer.metrics.CounterMetric;
import com.lightstep.tracer.metrics.Metric;
import com.lightstep.tracer.metrics.Sender;
import java.io.IOException;
import java.net.InetAddress;
import java.util.UUID;

abstract class ProtobufSender
extends Sender<IngestRequest.Builder, IngestResponse> {
    private final Reporter.Builder reporter;
    private final KeyValue.Builder[] labels;

    ProtobufSender(String componentName, String accessToken, String serviceVersion, String serviceUrl, boolean sendFirstReport) {
        super(componentName, accessToken, serviceVersion, serviceUrl, sendFirstReport);
        String hostname = ProtobufSender.getHostname();
        this.reporter = Reporter.newBuilder();
        this.reporter.addTags(KeyValue.newBuilder().setKey("lightstep.component_name").setStringValue(componentName));
        this.reporter.addTags(KeyValue.newBuilder().setKey("lightstep.hostname").setStringValue(hostname));
        this.reporter.addTags(KeyValue.newBuilder().setKey("lightstep.reporter_platform").setStringValue("java"));
        this.reporter.addTags(KeyValue.newBuilder().setKey("lightstep.reporter_platform_version").setStringValue(ProtobufSender.getJavaVersion()));
        this.reporter.addTags(KeyValue.newBuilder().setKey("service.version").setStringValue(serviceVersion));
        this.labels = new KeyValue.Builder[]{KeyValue.newBuilder().setKey("lightstep.component_name").setStringValue(componentName), KeyValue.newBuilder().setKey("lightstep.hostname").setStringValue(hostname), KeyValue.newBuilder().setKey("service.version").setStringValue(serviceVersion)};
    }

    @Override
    final <V extends Number> void createMessage(IngestRequest.Builder request, long timestampSeconds, long durationSeconds, Metric<?, V> metric, long current, long previous) throws IOException {
        MetricPoint.Builder builder = MetricPoint.newBuilder();
        builder.setMetricName(metric.getName());
        Timestamp.Builder timestamp = Timestamp.newBuilder();
        timestamp.setSeconds(timestampSeconds);
        builder.setStart(timestamp);
        Duration.Builder duration = Duration.newBuilder();
        duration.setSeconds(durationSeconds);
        builder.setDuration(duration);
        builder.setDoubleValue(metric.getValue(current, previous));
        if (metric instanceof CounterMetric) {
            builder.setKind(MetricKind.COUNTER);
        } else {
            builder.setKind(MetricKind.GAUGE);
        }
        for (int i = 0; i < this.labels.length; ++i) {
            builder.addLabels(this.labels[i]);
        }
        request.addPoints(builder.build());
    }

    private static String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (IOException e) {
            return "";
        }
    }

    private static String getJavaVersion() {
        return System.getProperty("java.version");
    }

    @Override
    IngestRequest.Builder newRequest() {
        return IngestRequest.newBuilder();
    }

    @Override
    IngestRequest.Builder setIdempotency(IngestRequest.Builder request) {
        return request.setIdempotencyKey(UUID.randomUUID().toString());
    }

    @Override
    IngestRequest.Builder setReporter(IngestRequest.Builder request) {
        return request.setReporter(this.reporter);
    }
}

