/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.metrics;

import com.lightstep.tracer.metrics.Metrics;
import com.lightstep.tracer.metrics.OkHttpSender;
import com.lightstep.tracer.shared.SafeMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeMetricsImpl
implements SafeMetrics {
    private static final Logger logger = LoggerFactory.getLogger(SafeMetricsImpl.class);
    private static final boolean isJdk17 = System.getProperty("java.version").startsWith("1.7");

    public Thread createMetricsThread(String componentName, String accessToken, String serviceVersion, String serviceUrl, int samplePeriodSeconds) {
        if (isJdk17) {
            logger.warn("Metrics supports jdk1.8+");
            return null;
        }
        OkHttpSender sender = new OkHttpSender(componentName, accessToken, serviceVersion, serviceUrl, samplePeriodSeconds * 1000, false);
        return new Metrics(sender, samplePeriodSeconds);
    }
}

