/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.metrics;

import com.lightstep.tracer.metrics.Metric;
import com.lightstep.tracer.metrics.MetricGroup;
import java.io.IOException;

public abstract class Sender<I, O>
implements AutoCloseable {
    protected final String componentName;
    protected final String accessToken;
    protected final String serviceVersion;
    protected final String serviceUrl;
    private I request;
    private long previousTimestamp = System.currentTimeMillis() / 1000L;
    private boolean readyToReport;
    private String reporter;
    private String version = null;

    Sender(String componentName, String accessToken, String serviceVersion, String serviceUrl, boolean sendFirstReport) {
        this.componentName = componentName;
        this.accessToken = accessToken;
        this.serviceVersion = serviceVersion;
        this.serviceUrl = serviceUrl;
        this.readyToReport = sendFirstReport;
    }

    abstract <V extends Number> void createMessage(I var1, long var2, long var4, Metric<?, V> var6, long var7, long var9) throws IOException;

    abstract I newRequest();

    abstract I setIdempotency(I var1);

    abstract I setReporter(I var1);

    abstract O invoke(I var1, long var2) throws Exception;

    final O exec(long timeout) throws Exception {
        I request = this.getRequest();
        if (request == null) {
            throw new IllegalStateException("Request should not be null");
        }
        if (!this.readyToReport) {
            this.readyToReport = true;
            return null;
        }
        O response = this.invoke(request, timeout);
        this.setRequest(null);
        return response;
    }

    final String getPlatformReporter() {
        if (this.reporter != null) {
            return this.reporter;
        }
        Package pkg = Sender.class.getPackage();
        String groupId = pkg.getName();
        String artifactId = pkg.getImplementationTitle();
        this.reporter = groupId == null ? "test" : groupId + ":" + artifactId;
        return this.reporter;
    }

    final String getPlatformVersion() {
        if (this.version != null) {
            return this.version;
        }
        this.version = Sender.class.getPackage().getImplementationVersion();
        if (this.version == null) {
            this.version = "0.0.0";
        }
        return this.version;
    }

    final I getRequest() {
        return this.request;
    }

    final void setRequest(I request) {
        this.request = request;
    }

    final long getPreviousTimestamp() {
        return this.previousTimestamp;
    }

    final void updateSampleRequest(MetricGroup[] metricGroups) throws IOException {
        long timestampSeconds = System.currentTimeMillis() / 1000L;
        long durationSeconds = timestampSeconds - this.getPreviousTimestamp();
        this.previousTimestamp = timestampSeconds;
        I request = this.setReporter(this.setIdempotency(this.request != null ? this.request : this.newRequest()));
        for (MetricGroup metricGroup : metricGroups) {
            metricGroup.execute(this, request, timestampSeconds, durationSeconds);
        }
        this.request = request;
    }
}

