/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.metrics;

import com.lightstep.tracer.grpc.MetricPoint;
import java.util.HashMap;

abstract class ValueAdapter<V extends Number> {
    private static final HashMap<Class<?>, ValueAdapter<?>> instances = new HashMap();
    static final ValueAdapter<Long> LONG = new ValueAdapter<Long>(Long.class){

        @Override
        long toLong(Long value) {
            return value;
        }

        @Override
        Long toT(long value) {
            return value;
        }

        @Override
        Long diff(long current, long previous) {
            return current - previous;
        }

        @Override
        void setValue(MetricPoint.Builder builder, Long value) {
            builder.setUint64Value(value);
        }
    };
    static final ValueAdapter<Double> DOUBLE = new ValueAdapter<Double>(Double.class){

        @Override
        long toLong(Double value) {
            return Double.doubleToLongBits(value);
        }

        @Override
        Double toT(long value) {
            return Double.longBitsToDouble(value);
        }

        @Override
        Double diff(long current, long previous) {
            return this.toT(current) - this.toT(previous);
        }

        @Override
        void setValue(MetricPoint.Builder builder, Double value) {
            builder.setDoubleValue(value);
        }
    };

    abstract V diff(long var1, long var3);

    abstract long toLong(V var1);

    abstract V toT(long var1);

    abstract void setValue(MetricPoint.Builder var1, V var2);

    private ValueAdapter(Class<V> type) {
        instances.put(type, this);
    }

    static <T extends Number> ValueAdapter<T> get(Class<T> type) {
        return instances.get(type);
    }
}

