/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.retry;

import com.lightstep.tracer.retry.RetryPolicy;

public class ExponentialBackoffRetryPolicy
extends RetryPolicy {
    private static final long serialVersionUID = -6999301056780454011L;
    private final int delayMs;
    private final double backoffFactor;
    private final int maxDelayMs;
    private final boolean noDelayOnFirstRetry;

    public ExponentialBackoffRetryPolicy(int maxRetries, int delayMs, double backoffFactor, int maxDelayMs, boolean noDelayOnFirstRetry, double jitter) {
        super(maxRetries, jitter);
        this.delayMs = delayMs;
        if (delayMs <= 0) {
            throw new IllegalArgumentException("delayMs (" + delayMs + ") must be a positive value");
        }
        this.backoffFactor = backoffFactor;
        if (backoffFactor < 1.0) {
            throw new IllegalArgumentException("backoffFactor (" + backoffFactor + ") must be >= 1.0");
        }
        this.maxDelayMs = maxDelayMs;
        if (maxDelayMs <= 0) {
            throw new IllegalArgumentException("maxDelayMs (" + maxDelayMs + ") must be a positive value");
        }
        this.noDelayOnFirstRetry = noDelayOnFirstRetry;
    }

    @Override
    public long getDelayMs(int attemptNo) {
        return Math.min(attemptNo == 1 && this.noDelayOnFirstRetry ? 0 : (int)((double)this.delayMs * StrictMath.pow(this.backoffFactor, attemptNo - 1)), this.maxDelayMs);
    }
}

