/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.retry;

import com.lightstep.tracer.retry.RetryPolicy;

public class LinearDelayRetryPolicy
extends RetryPolicy {
    private static final long serialVersionUID = -6090799745376513743L;
    private final int delayMs;
    private final boolean noDelayOnFirstRetry;

    public LinearDelayRetryPolicy(int maxRetries, int delayMs, boolean noDelayOnFirstRetry, double jitter) {
        super(maxRetries, jitter);
        this.noDelayOnFirstRetry = noDelayOnFirstRetry;
        this.delayMs = delayMs;
        if (delayMs <= 0) {
            throw new IllegalArgumentException("delayMs (" + delayMs + ") must be a positive value");
        }
    }

    @Override
    public long getDelayMs(int attemptNo) {
        return attemptNo == 1 && this.noDelayOnFirstRetry ? 0L : (long)this.delayMs;
    }
}

