/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.retry;

import com.lightstep.tracer.retry.RetryException;
import com.lightstep.tracer.retry.RetryFailureException;
import com.lightstep.tracer.retry.Retryable;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RetryPolicy
implements Serializable {
    private static final long serialVersionUID = -8480057566592276543L;
    private static final Logger logger = LoggerFactory.getLogger(RetryPolicy.class);
    private final int maxRetries;
    private final double jitter;

    public RetryPolicy(int maxRetries, double jitter) {
        if (maxRetries < 0) {
            throw new IllegalArgumentException("maxRetries (" + maxRetries + ") is negative");
        }
        if (jitter < 0.0) {
            throw new IllegalArgumentException("jitter (" + jitter + ") is negative");
        }
        this.maxRetries = maxRetries;
        this.jitter = jitter;
        if (maxRetries <= 0) {
            throw new IllegalArgumentException("maxRetries (" + maxRetries + ") must be a positive value");
        }
    }

    protected boolean retryOn(Exception e) {
        return e instanceof RetryException;
    }

    public final <T> T run(Retryable<T> retryable) throws RetryFailureException {
        return this.run0(retryable, 0L);
    }

    public final <T> T run(Retryable<T> retryable, long timeout) throws RetryFailureException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout value (" + timeout + ") is negative");
        }
        return this.run0(retryable, timeout);
    }

    private final <T> T run0(Retryable<T> retryable, long timeout) throws RetryFailureException {
        long startTime = System.currentTimeMillis();
        long runTime = 0L;
        int attemptNo = 1;
        while (true) {
            try {
                return retryable.retry(this, attemptNo);
            }
            catch (RetryFailureException e) {
                throw e;
            }
            catch (Exception e) {
                if (attemptNo > this.maxRetries || !this.retryOn(e)) {
                    throw new RetryFailureException(e, attemptNo, this.getDelayMs(attemptNo - 1));
                }
                long delayMs = this.getDelayMs(attemptNo);
                if (this.jitter > 0.0) {
                    delayMs = (long)((double)delayMs * (this.jitter * Math.random() + 1.0));
                }
                if (timeout > 0L) {
                    long remaining = timeout - runTime;
                    if (remaining <= 0L) {
                        throw new RetryFailureException(attemptNo, delayMs);
                    }
                    if (remaining < delayMs) {
                        delayMs = remaining;
                    }
                }
                try {
                    Thread.sleep(delayMs);
                    runTime = System.currentTimeMillis() - startTime;
                }
                catch (InterruptedException ie) {
                    throw new RetryFailureException(ie, attemptNo, delayMs);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Retrying attemptNo = " + attemptNo + ", runTime = " + runTime);
                }
                ++attemptNo;
                continue;
            }
            break;
        }
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public abstract long getDelayMs(int var1);
}

