/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.jre;

import com.lightstep.tracer.shared.AbstractTracer;
import com.lightstep.tracer.shared.Options;
import com.lightstep.tracer.shared.SimpleFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JRETracer
extends AbstractTracer {
    private static final int JRE_DEFAULT_REPORTING_INTERVAL_MILLIS = 2500;
    private static final Logger LOGGER = LoggerFactory.getLogger(JRETracer.class);

    public static JRETracer getInstance() {
        return JavaTracerHolder.INSTANCE;
    }

    public JRETracer(Options options) {
        super(options.setDefaultReportingIntervalMillis(2500));
        this.addStandardTracerTags();
    }

    protected SimpleFuture<Boolean> flushInternal(boolean explicitRequest) {
        return new SimpleFuture((Object)this.sendReport(explicitRequest));
    }

    protected void printLogToConsole(AbstractTracer.InternalLogLevel level, String msg, Object payload) {
        String s = msg;
        if (payload != null) {
            s = s + " " + payload.toString();
        }
        switch (level) {
            case DEBUG: {
                LOGGER.debug(s);
                break;
            }
            case INFO: {
                LOGGER.info(s);
                break;
            }
            case WARN: {
                LOGGER.warn(s);
                break;
            }
            case ERROR: {
                LOGGER.error(s);
            }
        }
    }

    private void addStandardTracerTags() {
        this.addTracerTag("lightstep.tracer_platform", "jre");
        this.addTracerTag("lightstep.tracer_platform_version", System.getProperty("java.version"));
        this.addTracerTag("lightstep.tracer_version", "0.15.4");
    }

    private static class JavaTracerHolder {
        private static final JRETracer INSTANCE = new JRETracer(null);

        private JavaTracerHolder() {
        }
    }
}

