/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.grpc;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;

public class GrpcClientInterceptor
implements ClientInterceptor {
    public static final Metadata.Key<String> ACCESS_TOKEN_HEADER = Metadata.Key.of((String)"Lightstep-Access-Token", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private String authToken;

    public GrpcClientInterceptor(String authToken) {
        this.authToken = authToken;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(channel.newCall(methodDescriptor, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                headers.put(ACCESS_TOKEN_HEADER, (Object)GrpcClientInterceptor.this.authToken);
                super.start(responseListener, headers);
            }
        };
    }
}

