/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.shared;

import com.lightstep.tracer.grpc.CollectorServiceGrpc;
import com.lightstep.tracer.grpc.GrpcClientInterceptor;
import com.lightstep.tracer.grpc.ReportRequest;
import com.lightstep.tracer.grpc.ReportResponse;
import com.lightstep.tracer.shared.AbstractTracer;
import com.lightstep.tracer.shared.CollectorClient;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.StatusRuntimeException;
import java.util.concurrent.TimeUnit;

class GrpcCollectorClient
extends CollectorClient {
    private final ManagedChannelBuilder<?> channelBuilder;
    private ManagedChannel channel;
    private CollectorServiceGrpc.CollectorServiceBlockingStub blockingStub;
    private final AbstractTracer tracer;
    private final long deadlineMillis;

    GrpcCollectorClient(AbstractTracer tracer, ManagedChannelBuilder channelBuilder, long deadlineMillis) {
        this.tracer = tracer;
        this.channelBuilder = channelBuilder;
        this.deadlineMillis = deadlineMillis;
        this.connect();
    }

    synchronized void shutdown() {
        try {
            this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.tracer.warn("Interrupted while shutting down client, force shutdown now!");
            this.channel.shutdownNow();
        }
    }

    synchronized ReportResponse report(ReportRequest request) {
        try {
            ReportResponse response = ((CollectorServiceGrpc.CollectorServiceBlockingStub)((CollectorServiceGrpc.CollectorServiceBlockingStub)this.blockingStub.withDeadlineAfter(this.deadlineMillis, TimeUnit.MILLISECONDS)).withInterceptors(new ClientInterceptor[]{new GrpcClientInterceptor(request.getAuth().getAccessToken())})).report(request);
            return response;
        }
        catch (StatusRuntimeException e) {
            this.tracer.error("Status runtime exception (likely malformed spans): ", (Object)e);
        }
        catch (Exception e) {
            this.tracer.error("Exception sending report to collector: ", (Object)e);
        }
        return null;
    }

    private synchronized void connect() {
        this.channel = this.channelBuilder.build();
        this.blockingStub = CollectorServiceGrpc.newBlockingStub((Channel)this.channel);
    }

    synchronized void reconnect() {
        this.shutdown();
        this.connect();
    }
}

