/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.shared;

import com.lightstep.tracer.shared.AbstractTracer;
import com.lightstep.tracer.shared.CollectorClientProvider;
import com.lightstep.tracer.shared.GrpcCollectorClient;
import com.lightstep.tracer.shared.Options;
import io.grpc.ManagedChannelBuilder;
import io.grpc.ManagedChannelProvider;

public class GrpcCollectorClientProvider
extends CollectorClientProvider {
    private static GrpcCollectorClientProvider INSTANCE = new GrpcCollectorClientProvider();

    public static GrpcCollectorClientProvider provider() {
        return INSTANCE;
    }

    public GrpcCollectorClientProvider() {
        ManagedChannelProvider.provider();
    }

    protected int priority() {
        return 1;
    }

    protected Options.CollectorClient type() {
        return Options.CollectorClient.GRPC;
    }

    GrpcCollectorClient forOptions(AbstractTracer tracer, Options options) {
        try {
            ManagedChannelBuilder builder = options.grpcCollectorTarget != null ? ManagedChannelBuilder.forTarget((String)options.grpcCollectorTarget) : ManagedChannelBuilder.forAddress((String)options.collectorUrl.getHost(), (int)options.collectorUrl.getPort());
            if (options.grpcRoundRobin) {
                builder.defaultLoadBalancingPolicy("round_robin");
            }
            if (options.collectorUrl.getProtocol().equals("http")) {
                builder.usePlaintext();
            }
            return new GrpcCollectorClient(tracer, builder, options.deadlineMillis);
        }
        catch (ManagedChannelProvider.ProviderNotFoundException e) {
            return null;
        }
    }
}

