/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.shared;

import com.lightstep.tracer.grpc.ReportRequest;
import com.lightstep.tracer.grpc.ReportResponse;
import com.lightstep.tracer.shared.AbstractTracer;
import com.lightstep.tracer.shared.CollectorClient;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

class HttpCollectorClient
extends CollectorClient {
    private static final MediaType protoMediaType = MediaType.parse((String)"application/octet-stream");
    private final AtomicReference<OkHttpClient> client;
    private final AbstractTracer tracer;
    private final URL collectorURL;
    private final long deadlineMillis;

    HttpCollectorClient(AbstractTracer tracer, URL collectorURL, long deadlineMillis) {
        this.client = new AtomicReference<OkHttpClient>(HttpCollectorClient.start(deadlineMillis));
        this.tracer = tracer;
        this.collectorURL = collectorURL;
        this.deadlineMillis = deadlineMillis;
    }

    ReportResponse report(ReportRequest request) {
        try {
            return this.fromResponse(this.client().newCall(this.toRequest(request)).execute());
        }
        catch (Exception e) {
            this.tracer.error("Exception sending report to collector: ", (Object)e);
            return null;
        }
    }

    void reconnect() {
        HttpCollectorClient.shutdown(this.client.getAndSet(HttpCollectorClient.start(this.deadlineMillis)));
    }

    void shutdown() {
        HttpCollectorClient.shutdown(this.client());
    }

    private OkHttpClient client() {
        return this.client.get();
    }

    private Request toRequest(ReportRequest request) {
        return new Request.Builder().url(this.collectorURL).post(RequestBody.create((MediaType)protoMediaType, (byte[])request.toByteArray())).build();
    }

    private ReportResponse fromResponse(Response response) throws IOException {
        try {
            if (!response.isSuccessful()) {
                this.tracer.error(String.format("Collector returned non-successful http code %d", response.code()));
                ReportResponse reportResponse = null;
                return reportResponse;
            }
            ReportResponse reportResponse = this.fromResponseBody(response.body());
            return reportResponse;
        }
        finally {
            response.close();
        }
    }

    private ReportResponse fromResponseBody(ResponseBody body) throws IOException {
        if (body == null) {
            this.tracer.error("Collector returned an empty body");
            return null;
        }
        return ReportResponse.parseFrom((InputStream)body.byteStream());
    }

    private static void shutdown(OkHttpClient client) {
        client.dispatcher().executorService().shutdown();
    }

    private static OkHttpClient start(long deadlineMillis) {
        return new OkHttpClient.Builder().connectTimeout(deadlineMillis, TimeUnit.MILLISECONDS).build();
    }
}

