/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.cloudwatch.logback.appender;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import com.amazonaws.services.logs.AWSLogs;
import com.amazonaws.services.logs.AWSLogsClientBuilder;
import com.amazonaws.services.logs.model.CreateLogGroupRequest;
import com.amazonaws.services.logs.model.CreateLogStreamRequest;
import com.amazonaws.services.logs.model.InputLogEvent;
import com.amazonaws.services.logs.model.InvalidSequenceTokenException;
import com.amazonaws.services.logs.model.PutLogEventsRequest;
import com.amazonaws.services.logs.model.PutLogEventsResult;
import com.amazonaws.services.logs.model.ResourceAlreadyExistsException;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.lightstreamer.cloudwatch.logback.appender.Event;
import com.lightstreamer.cloudwatch.logback.appender.LogbackUtils;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public final class AwsLogsJsonAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private final ObjectMapper om = new ObjectMapper().findAndRegisterModules();
    private AWSLogs awsLogsClient;
    private String awsRegionName;
    private String createLogGroup = "false";
    private String logGroupName = "test-log-group";
    private String logStreamName;
    private int maxLogSize = 1024;
    private long logPollTimeMillis = 3000L;
    private WorkerThread workerThread;
    private ArrayBlockingQueue<Event> logEvents;

    public AwsLogsJsonAppender() {
        this.om.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.om.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        this.om.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.om.configure(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS, false);
        this.om.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public void start() {
        super.start();
        this.addInfo(((Object)((Object)this)).getClass().getSimpleName() + " start " + this.getName());
        if (this.logStreamName == null) {
            try {
                this.logStreamName = LogbackUtils.dateFormatThreadLocal.get().format(System.currentTimeMillis()) + ' ' + InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (Exception e) {
                this.logStreamName = LogbackUtils.dateFormatThreadLocal.get().format(System.currentTimeMillis());
            }
            this.logStreamName = this.logStreamName.replace(':', '.');
        }
        AWSLogsClientBuilder logsClientBuilder = AWSLogsClientBuilder.standard();
        if (this.awsRegionName != null) {
            logsClientBuilder.setRegion(this.awsRegionName);
        }
        this.awsLogsClient = (AWSLogs)logsClientBuilder.build();
        this.logEvents = new ArrayBlockingQueue(this.maxLogSize * 2);
    }

    public void stop() {
        super.stop();
        this.addInfo(((Object)((Object)this)).getClass().getSimpleName() + " stopping " + this.getName());
        if (this.workerThread != null) {
            try {
                this.workerThread.join(this.logPollTimeMillis);
            }
            catch (InterruptedException e) {
                this.addWarn(this.workerThread.getName() + " interrupted", e);
            }
            this.workerThread.interrupt();
            this.workerThread = null;
        }
        this.addInfo(((Object)((Object)this)).getClass().getSimpleName() + " stopped " + this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append(ILoggingEvent eventObject) {
        block6: {
            try {
                this.logEvents.offer(LogbackUtils.iLoggingEvent2Map(eventObject));
                if (this.workerThread != null && this.workerThread.isAlive()) break block6;
                AwsLogsJsonAppender awsLogsJsonAppender = this;
                synchronized (awsLogsJsonAppender) {
                    if (this.workerThread == null || !this.workerThread.isAlive()) {
                        this.workerThread = new WorkerThread(((Object)((Object)this)).getClass().getSimpleName() + ' ' + this.getName());
                        this.workerThread.start();
                    }
                }
            }
            catch (Exception e) {
                this.addError("Error while sending a message", e);
            }
        }
    }

    public void setAwsRegionName(String awsRegionName) {
        this.awsRegionName = awsRegionName;
    }

    public void setCreateLogGroup(String createLogGroup) {
        this.createLogGroup = createLogGroup;
    }

    public void setLogGroupName(String logGroupName) {
        this.logGroupName = logGroupName;
    }

    public void setLogStreamName(String logStreamName) {
        this.logStreamName = logStreamName;
    }

    public void setMaxLogSize(String maxLogSize) {
        this.maxLogSize = Integer.valueOf(maxLogSize);
    }

    public void setLogPollTimeMillis(String logPollTimeMillis) {
        this.logPollTimeMillis = Long.valueOf(logPollTimeMillis);
    }

    private final class WorkerThread
    extends Thread {
        private final List<InputLogEvent> logs;

        WorkerThread(String name) {
            super(name);
            this.logs = new ArrayList<InputLogEvent>(AwsLogsJsonAppender.this.maxLogSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            assert (AwsLogsJsonAppender.this.isStarted());
            try {
                AwsLogsJsonAppender.this.addInfo(this.getClass().getSimpleName() + " starting thread " + AwsLogsJsonAppender.this.workerThread.getName());
                if (Boolean.parseBoolean(AwsLogsJsonAppender.this.createLogGroup)) {
                    CreateLogGroupRequest createLogGroupRequest = new CreateLogGroupRequest(AwsLogsJsonAppender.this.logGroupName);
                    try {
                        AwsLogsJsonAppender.this.awsLogsClient.createLogGroup(createLogGroupRequest);
                    }
                    catch (ResourceAlreadyExistsException e) {
                        AwsLogsJsonAppender.this.addInfo("Log group " + AwsLogsJsonAppender.this.logGroupName + "already exists");
                    }
                }
                CreateLogStreamRequest createLogStreamRequest = new CreateLogStreamRequest(AwsLogsJsonAppender.this.logGroupName, AwsLogsJsonAppender.this.logStreamName);
                try {
                    AwsLogsJsonAppender.this.awsLogsClient.createLogStream(createLogStreamRequest);
                }
                catch (ResourceAlreadyExistsException e) {
                    AwsLogsJsonAppender.this.addInfo("Log stream " + AwsLogsJsonAppender.this.logStreamName + "already exists", e);
                }
                long lastSubmit = System.currentTimeMillis();
                String lastSequenceToken = null;
                while (AwsLogsJsonAppender.this.isStarted()) {
                    long pollRemainTime = lastSubmit + AwsLogsJsonAppender.this.logPollTimeMillis - System.currentTimeMillis();
                    while (pollRemainTime > 0L && this.logs.size() < AwsLogsJsonAppender.this.maxLogSize) {
                        try {
                            Event event = (Event)AwsLogsJsonAppender.this.logEvents.poll(pollRemainTime, TimeUnit.MILLISECONDS);
                            long now = System.currentTimeMillis();
                            if (event != null) {
                                InputLogEvent inputLogEvent = new InputLogEvent();
                                inputLogEvent.setMessage(AwsLogsJsonAppender.this.om.writeValueAsString((Object)event));
                                inputLogEvent.setTimestamp(Long.valueOf(now));
                                this.logs.add(inputLogEvent);
                            }
                            pollRemainTime = lastSubmit - now + AwsLogsJsonAppender.this.logPollTimeMillis;
                        }
                        catch (InterruptedException e) {
                            AwsLogsJsonAppender.this.addInfo(Thread.currentThread().getName() + " interrupted");
                            pollRemainTime = -1L;
                        }
                        catch (JsonProcessingException e) {
                            AwsLogsJsonAppender.this.addError("Unable to serialize message", e);
                        }
                    }
                    if (!this.logs.isEmpty()) {
                        try {
                            PutLogEventsRequest putLogEventsRequest = new PutLogEventsRequest(AwsLogsJsonAppender.this.logGroupName, AwsLogsJsonAppender.this.logStreamName, this.logs);
                            putLogEventsRequest.setSequenceToken(lastSequenceToken);
                            PutLogEventsResult putLogEventsResult = AwsLogsJsonAppender.this.awsLogsClient.putLogEvents(putLogEventsRequest);
                            lastSequenceToken = putLogEventsResult.getNextSequenceToken();
                            this.logs.clear();
                        }
                        catch (InvalidSequenceTokenException e) {
                            lastSequenceToken = e.getExpectedSequenceToken();
                        }
                    }
                    lastSubmit = System.currentTimeMillis();
                }
            }
            catch (Exception e) {
                AwsLogsJsonAppender.this.addError("Cloudwatch appender thread error", e);
            }
            finally {
                AwsLogsJsonAppender.this.addInfo(this.getClass().getSimpleName() + " stopped thread " + Thread.currentThread().getName());
            }
        }
    }
}

