/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.cloudwatch.logback.appender;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import com.lightstreamer.cloudwatch.logback.appender.Event;
import com.lightstreamer.cloudwatch.logback.appender.ThrowableProxy;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Marker;

final class LogbackUtils {
    static ThreadLocal<DateFormat> dateFormatThreadLocal = ThreadLocal.withInitial(() -> {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat;
    });

    static Event iLoggingEvent2Map(ILoggingEvent eventObject) {
        Event event = new Event();
        event.message = eventObject.getFormattedMessage();
        event.level = eventObject.getLevel().toString();
        event.threadName = eventObject.getThreadName();
        event.loggerName = eventObject.getLoggerName();
        event.throwableProxy = LogbackUtils.getThrowableProxyMap(eventObject.getThrowableProxy());
        event.markers = LogbackUtils.getMarkers(eventObject);
        event.timeStamp = dateFormatThreadLocal.get().format(eventObject.getTimeStamp());
        Map mdcPropertyMap = eventObject.getMDCPropertyMap();
        if (!mdcPropertyMap.isEmpty()) {
            event.mdcPropertyMap = new TreeMap<String, String>(mdcPropertyMap);
        }
        if (eventObject.hasCallerData()) {
            event.callerData = eventObject.getCallerData();
        }
        return event;
    }

    private static ThrowableProxy getThrowableProxyMap(IThrowableProxy iThrowableProxy) {
        if (iThrowableProxy == null) {
            return null;
        }
        ThrowableProxy throwableProxy = new ThrowableProxy();
        throwableProxy.message = iThrowableProxy.getMessage();
        throwableProxy.className = iThrowableProxy.getClassName();
        throwableProxy.cause = LogbackUtils.getThrowableProxyMap(iThrowableProxy.getCause());
        StackTraceElementProxy[] stackTraceElementProxyArray = iThrowableProxy.getStackTraceElementProxyArray();
        throwableProxy.stackTraceElements = new String[stackTraceElementProxyArray.length];
        int i = 0;
        for (StackTraceElementProxy stackTraceElementProxy : stackTraceElementProxyArray) {
            throwableProxy.stackTraceElements[i] = stackTraceElementProxy.getStackTraceElement().toString();
            ++i;
        }
        return throwableProxy;
    }

    private static Set<String> getMarkers(ILoggingEvent eventObject) {
        Marker marker = eventObject.getMarker();
        if (marker == null) {
            return null;
        }
        TreeSet<String> markers = new TreeSet<String>();
        Iterator i = marker.iterator();
        while (i.hasNext()) {
            markers.add(i.next().toString());
        }
        return markers;
    }

    private LogbackUtils() {
    }
}

