/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.apng;

import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import androidx.annotation.DrawableRes;
import androidx.annotation.IntRange;
import androidx.annotation.RawRes;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.vectordrawable.graphics.drawable.Animatable2Compat;
import com.linecorp.apng.RepeatAnimationCallback;
import com.linecorp.apng.decoder.Apng;
import com.linecorp.apng.decoder.ApngException;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 f2\u00020\u00012\u00020\u0002:\u0002efB\u000f\b\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J!\u00109\u001a\u00020\u00112\u0006\u0010:\u001a\u00020\u00112\u0006\u0010;\u001a\u00020\u00112\u0006\u0010<\u001a\u00020\u0007H\u0082\u0010J\b\u0010=\u001a\u00020>H\u0016J\b\u0010?\u001a\u00020>H\u0002J\u0010\u0010@\u001a\u00020>2\u0006\u0010A\u001a\u00020BH\u0016J\b\u0010C\u001a\u00020)H\u0002J\n\u0010D\u001a\u0004\u0018\u00010EH\u0016J\b\u0010F\u001a\u00020\u0011H\u0016J\b\u0010G\u001a\u00020\u0011H\u0016J\b\u0010H\u001a\u00020\u0011H\u0016J\b\u0010I\u001a\u00020)H\u0002J\b\u0010J\u001a\u00020)H\u0002J\b\u0010K\u001a\u00020)H\u0002J\b\u0010L\u001a\u00020)H\u0002J\b\u0010M\u001a\u00020)H\u0016J\b\u0010N\u001a\u00020\u0001H\u0016J\b\u0010O\u001a\u00020>H\u0002J\u0006\u0010P\u001a\u00020>J\u0010\u0010Q\u001a\u00020>2\u0006\u0010R\u001a\u00020\fH\u0016J\u000e\u0010S\u001a\u00020>2\u0006\u0010T\u001a\u000204J\u0010\u0010U\u001a\u00020>2\b\b\u0001\u0010V\u001a\u00020\u0007J\u001a\u0010W\u001a\u00020>2\b\b\u0001\u0010X\u001a\u00020\u00112\b\b\u0001\u0010Y\u001a\u00020\u0011J\u0010\u0010Z\u001a\u00020>2\u0006\u0010[\u001a\u00020\u0011H\u0016J\u0012\u0010\\\u001a\u00020>2\b\u0010]\u001a\u0004\u0018\u00010^H\u0016J\u000e\u00108\u001a\u00020>2\u0006\u0010_\u001a\u00020`J\b\u0010a\u001a\u00020>H\u0016J\b\u0010b\u001a\u00020>H\u0016J\u0010\u0010c\u001a\u00020)2\u0006\u0010R\u001a\u00020\fH\u0016J\u000e\u0010d\u001a\u00020)2\u0006\u0010T\u001a\u000204R\u0016\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u001a\u0010\u0018\u001a\u00020\u00118FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u0013R\u0016\u0010\u001c\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0013R\u0016\u0010\u001e\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0013R\u0016\u0010 \u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0013R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00110#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010(\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010*R\u000e\u0010+\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010-\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u00118\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u0013\"\u0004\b/\u00100R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00103\u001a\b\u0012\u0004\u0012\u0002040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u00107\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u0011@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b8\u00100\u00a8\u0006g"}, d2={"Lcom/linecorp/apng/ApngDrawable;", "Landroid/graphics/drawable/Drawable;", "Landroidx/vectordrawable/graphics/drawable/Animatable2Compat;", "apngState", "Lcom/linecorp/apng/ApngDrawable$ApngState;", "(Lcom/linecorp/apng/ApngDrawable$ApngState;)V", "allocationByteCount", "", "getAllocationByteCount", "()J", "animationCallbacks", "", "Landroidx/vectordrawable/graphics/drawable/Animatable2Compat$AnimationCallback;", "animationElapsedTimeMillis", "animationPrevDrawTimeMillis", "Ljava/lang/Long;", "currentFrameIndex", "", "getCurrentFrameIndex", "()I", "currentLoopIndex", "getCurrentLoopIndex", "currentLoopIndexInternal", "getCurrentLoopIndexInternal", "currentRepeatCount", "getCurrentRepeatCount$annotations", "()V", "getCurrentRepeatCount", "durationMillis", "getDurationMillis", "frameByteCount", "getFrameByteCount", "frameCount", "getFrameCount", "frameDurations", "", "getFrameDurations", "()Ljava/util/List;", "frameStartTimes", "", "isRecycled", "", "()Z", "isStarted", "value", "loopCount", "getLoopCount", "setLoopCount", "(I)V", "paint", "Landroid/graphics/Paint;", "repeatAnimationCallbacks", "Lcom/linecorp/apng/RepeatAnimationCallback;", "scaledHeight", "scaledWidth", "targetDensity", "setTargetDensity", "calculateCurrentFrameIndex", "lowerBoundIndex", "upperBoundIndex", "progressMillisInCurrentLoop", "clearAnimationCallbacks", "", "computeBitmapSize", "draw", "canvas", "Landroid/graphics/Canvas;", "exceedsRepeatCountLimitation", "getConstantState", "Landroid/graphics/drawable/Drawable$ConstantState;", "getIntrinsicHeight", "getIntrinsicWidth", "getOpacity", "hasNextLoop", "isFirstFrame", "isFirstLoop", "isLastFrame", "isRunning", "mutate", "progressAnimationElapsedTime", "recycle", "registerAnimationCallback", "callback", "registerRepeatAnimationCallback", "repeatCallback", "seekTo", "positionMillis", "seekToFrame", "loopIndex", "frameIndex", "setAlpha", "alpha", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "metrics", "Landroid/util/DisplayMetrics;", "start", "stop", "unregisterAnimationCallback", "unregisterRepeatAnimationCallback", "ApngState", "Companion", "apng-drawable_release"})
public final class ApngDrawable
extends Drawable
implements Animatable2Compat {
    @IntRange(from=0L, to=0x7FFFFFFFL)
    private final int durationMillis;
    @IntRange(from=1L, to=0x7FFFFFFFL)
    private final int frameCount;
    @NotNull
    private final List<Integer> frameDurations;
    @IntRange(from=0L, to=0x7FFFFFFFL)
    private final int frameByteCount;
    @IntRange(from=0L, to=0x7FFFFFFFL)
    private final long allocationByteCount;
    @IntRange(from=-1L, to=0x7FFFFFFFL)
    private int loopCount;
    private final boolean isRecycled;
    private final Paint paint;
    private final List<Animatable2Compat.AnimationCallback> animationCallbacks;
    private final List<RepeatAnimationCallback> repeatAnimationCallbacks;
    private final int[] frameStartTimes;
    private int scaledWidth;
    private int scaledHeight;
    private boolean isStarted;
    private long animationElapsedTimeMillis;
    private Long animationPrevDrawTimeMillis;
    private int targetDensity;
    private ApngState apngState;
    public static final int LOOP_FOREVER = 0;
    public static final int LOOP_INTRINSIC = -1;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final int getDurationMillis() {
        return this.durationMillis;
    }

    public final int getFrameCount() {
        return this.frameCount;
    }

    @NotNull
    public final List<Integer> getFrameDurations() {
        return this.frameDurations;
    }

    public final int getFrameByteCount() {
        return this.frameByteCount;
    }

    public final long getAllocationByteCount() {
        return this.allocationByteCount;
    }

    public final int getLoopCount() {
        return this.loopCount;
    }

    public final void setLoopCount(int value) {
        boolean bl = value >= -1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "`loopCount` must be a signed value or special values. (value = " + value + ')';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.loopCount = value == -1 ? this.apngState.getApng().getLoopCount() : value;
    }

    public final boolean isRecycled() {
        return this.isRecycled;
    }

    @Deprecated(message="Use currentLoopIndex", replaceWith=@ReplaceWith(imports={}, expression="currentLoopIndex + 1"))
    public static /* synthetic */ void getCurrentRepeatCount$annotations() {
    }

    public final int getCurrentRepeatCount() {
        return this.getCurrentLoopIndex() + 1;
    }

    public final int getCurrentLoopIndex() {
        int n = this.getCurrentLoopIndexInternal();
        int n2 = this.loopCount - 1;
        boolean bl = false;
        return Math.min(n, n2);
    }

    public final int getCurrentFrameIndex() {
        long progressMillisInCurrentLoop = this.animationElapsedTimeMillis % (long)this.durationMillis;
        return this.calculateCurrentFrameIndex(0, this.frameCount - 1, progressMillisInCurrentLoop += (long)(this.exceedsRepeatCountLimitation() ? this.durationMillis : 0));
    }

    private final int getCurrentLoopIndexInternal() {
        return (int)(this.animationElapsedTimeMillis / (long)this.durationMillis);
    }

    private final void setTargetDensity(int value) {
        if (this.targetDensity != value) {
            this.targetDensity = value == 0 ? 160 : value;
            this.computeBitmapSize();
            this.invalidateSelf();
        }
    }

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (this.isStarted) {
            this.progressAnimationElapsedTime();
        }
        Apng apng = this.apngState.getApng();
        int n = this.getCurrentFrameIndex();
        Rect rect = this.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"bounds");
        apng.drawWithIndex(n, canvas, null, rect, this.paint);
        if (this.isStarted) {
            this.invalidateSelf();
        }
    }

    public void setAlpha(int alpha) {
        this.paint.setAlpha(alpha);
    }

    public int getOpacity() {
        return -2;
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.paint.setColorFilter(colorFilter);
    }

    public int getIntrinsicWidth() {
        return this.scaledWidth;
    }

    public int getIntrinsicHeight() {
        return this.scaledHeight;
    }

    public boolean isRunning() {
        return this.isStarted;
    }

    public void start() {
        this.isStarted = true;
        this.animationPrevDrawTimeMillis = null;
        this.invalidateSelf();
    }

    public void stop() {
        this.isStarted = false;
        this.invalidateSelf();
    }

    public void registerAnimationCallback(@NotNull Animatable2Compat.AnimationCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.animationCallbacks.add(callback);
    }

    public boolean unregisterAnimationCallback(@NotNull Animatable2Compat.AnimationCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        return this.animationCallbacks.remove(callback);
    }

    public final void registerRepeatAnimationCallback(@NotNull RepeatAnimationCallback repeatCallback) {
        Intrinsics.checkNotNullParameter((Object)repeatCallback, (String)"repeatCallback");
        this.repeatAnimationCallbacks.add(repeatCallback);
    }

    public final boolean unregisterRepeatAnimationCallback(@NotNull RepeatAnimationCallback repeatCallback) {
        Intrinsics.checkNotNullParameter((Object)repeatCallback, (String)"repeatCallback");
        return this.repeatAnimationCallbacks.remove(repeatCallback);
    }

    public void clearAnimationCallbacks() {
        this.animationCallbacks.clear();
    }

    @Nullable
    public Drawable.ConstantState getConstantState() {
        return this.apngState;
    }

    @NotNull
    public Drawable mutate() {
        this.apngState = new ApngState(this.apngState);
        return this;
    }

    public final void setTargetDensity(@NotNull DisplayMetrics metrics) {
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        this.setTargetDensity(metrics.densityDpi);
    }

    public final void seekTo(@IntRange(from=0L, to=0x7FFFFFFFFFFFFFFFL) long positionMillis) {
        boolean bl = positionMillis >= 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "positionMillis must be positive value";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.animationPrevDrawTimeMillis = null;
        this.animationElapsedTimeMillis = positionMillis;
        this.invalidateSelf();
    }

    public final void seekToFrame(@IntRange(from=0L, to=0x7FFFFFFFL) int loopIndex, @IntRange(from=0L, to=0x7FFFFFFFL) int frameIndex) {
        boolean bl = loopIndex >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "loopIndex must be positive value";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = frameIndex >= 0;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "frameIndex must be positive value";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = loopIndex < this.loopCount;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "loopIndex must be less than loopCount." + " loopIndex = " + loopIndex + ", loopCount = " + this.loopCount + '.';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = frameIndex < this.frameCount;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl7 = false;
            String string = "frameIndex must be less than frameCount." + " frameIndex = " + frameIndex + ", frameCount = " + this.frameCount + '.';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.seekTo((long)loopIndex * (long)this.durationMillis + (long)this.frameStartTimes[frameIndex]);
    }

    public final void recycle() {
        this.apngState.getApng().recycle();
    }

    private final void progressAnimationElapsedTime() {
        Object it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        boolean frameChanged;
        int lastFrame = this.getCurrentFrameIndex();
        long currentTimeMillis = ((Number)this.apngState.getCurrentTimeProvider().invoke()).longValue();
        Long animationPrevDrawTimeMillisSnapShot = this.animationPrevDrawTimeMillis;
        this.animationElapsedTimeMillis = animationPrevDrawTimeMillisSnapShot == null ? this.animationElapsedTimeMillis : this.animationElapsedTimeMillis + currentTimeMillis - animationPrevDrawTimeMillisSnapShot;
        this.animationPrevDrawTimeMillis = currentTimeMillis;
        boolean bl = frameChanged = this.getCurrentFrameIndex() != lastFrame;
        if (this.isStarted) {
            if (this.isFirstFrame() && this.isFirstLoop() && animationPrevDrawTimeMillisSnapShot == null) {
                $this$forEach$iv = this.animationCallbacks;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Animatable2Compat.AnimationCallback)element$iv;
                    boolean bl2 = false;
                    it.onAnimationStart((Drawable)this);
                }
            } else if (this.isLastFrame() && this.hasNextLoop() && frameChanged) {
                $this$forEach$iv = this.repeatAnimationCallbacks;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (RepeatAnimationCallback)element$iv;
                    boolean bl3 = false;
                    it.onRepeat(this, this.getCurrentLoopIndexInternal() + 2);
                    it.onAnimationRepeat(this, this.getCurrentLoopIndexInternal() + 1);
                }
            }
        }
        if (this.exceedsRepeatCountLimitation()) {
            this.isStarted = false;
            $this$forEach$iv = this.animationCallbacks;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Animatable2Compat.AnimationCallback)element$iv;
                boolean bl4 = false;
                it.onAnimationEnd((Drawable)this);
            }
        }
    }

    private final boolean isFirstFrame() {
        return this.getCurrentFrameIndex() == 0;
    }

    private final boolean isLastFrame() {
        return this.getCurrentFrameIndex() == this.frameCount - 1;
    }

    private final boolean isFirstLoop() {
        return this.getCurrentLoopIndexInternal() == 0;
    }

    private final boolean hasNextLoop() {
        if (this.loopCount == 0) {
            return true;
        }
        return this.getCurrentLoopIndexInternal() < this.loopCount - 1;
    }

    private final boolean exceedsRepeatCountLimitation() {
        if (this.loopCount == 0) {
            return false;
        }
        return this.getCurrentLoopIndexInternal() > this.loopCount - 1;
    }

    private final void computeBitmapSize() {
        this.scaledWidth = ApngDrawable.Companion.scaleFromDensity(this.apngState.getWidth(), this.apngState.getSourceDensity(), this.targetDensity);
        this.scaledHeight = ApngDrawable.Companion.scaleFromDensity(this.apngState.getHeight(), this.apngState.getSourceDensity(), this.targetDensity);
        this.getBounds().set(0, 0, this.scaledWidth, this.scaledHeight);
    }

    private final int calculateCurrentFrameIndex(int lowerBoundIndex, int upperBoundIndex, long progressMillisInCurrentLoop) {
        int middleIndex;
        while (true) {
            middleIndex = (lowerBoundIndex + upperBoundIndex) / 2;
            if (this.frameStartTimes.length > middleIndex + 1 && progressMillisInCurrentLoop >= (long)this.frameStartTimes[middleIndex + 1]) {
                lowerBoundIndex = middleIndex + 1;
                continue;
            }
            if (lowerBoundIndex == upperBoundIndex || progressMillisInCurrentLoop >= (long)this.frameStartTimes[middleIndex]) break;
            upperBoundIndex = middleIndex;
        }
        return middleIndex;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public ApngDrawable(@NotNull ApngState apngState) {
        Intrinsics.checkNotNullParameter((Object)((Object)apngState), (String)"apngState");
        this.apngState = apngState;
        this.durationMillis = this.apngState.getApng().getDuration();
        this.frameCount = this.apngState.getApng().getFrameCount();
        this.frameDurations = ArraysKt.toList((int[])this.apngState.getApng().getFrameDurations());
        this.frameByteCount = this.apngState.getApng().getByteCount();
        this.allocationByteCount = this.apngState.getApng().getAllFrameByteCount() + (long)this.frameByteCount;
        this.loopCount = this.apngState.getApng().getLoopCount();
        this.isRecycled = this.apngState.getApng().isRecycled();
        this.paint = new Paint(6);
        int n = 0;
        this.animationCallbacks = new ArrayList();
        n = 0;
        this.repeatAnimationCallbacks = new ArrayList();
        this.frameStartTimes = new int[this.frameCount];
        this.scaledWidth = this.apngState.getWidth();
        this.scaledHeight = this.apngState.getHeight();
        this.targetDensity = 160;
        n = 1;
        int n2 = this.frameCount;
        while (n < n2) {
            void i;
            this.frameStartTimes[i] = this.frameStartTimes[i - true] + this.apngState.getApng().getFrameDurations()[i - true];
            ++i;
        }
        this.getBounds().set(0, 0, this.apngState.getWidth(), this.apngState.getHeight());
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0003B;\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0016\u001a\u00020\u0007H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lcom/linecorp/apng/ApngDrawable$ApngState;", "Landroid/graphics/drawable/Drawable$ConstantState;", "apngState", "(Lcom/linecorp/apng/ApngDrawable$ApngState;)V", "apng", "Lcom/linecorp/apng/decoder/Apng;", "width", "", "height", "sourceDensity", "currentTimeProvider", "Lkotlin/Function0;", "", "(Lcom/linecorp/apng/decoder/Apng;IIILkotlin/jvm/functions/Function0;)V", "getApng", "()Lcom/linecorp/apng/decoder/Apng;", "getCurrentTimeProvider", "()Lkotlin/jvm/functions/Function0;", "getHeight", "()I", "getSourceDensity", "getWidth", "getChangingConfigurations", "newDrawable", "Landroid/graphics/drawable/Drawable;", "apng-drawable_release"})
    public static final class ApngState
    extends Drawable.ConstantState {
        @NotNull
        private final Apng apng;
        private final int width;
        private final int height;
        private final int sourceDensity;
        @NotNull
        private final Function0<Long> currentTimeProvider;

        @NotNull
        public Drawable newDrawable() {
            return new ApngDrawable(new ApngState(this));
        }

        public int getChangingConfigurations() {
            return 0;
        }

        @NotNull
        public final Apng getApng() {
            return this.apng;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        public final int getSourceDensity() {
            return this.sourceDensity;
        }

        @NotNull
        public final Function0<Long> getCurrentTimeProvider() {
            return this.currentTimeProvider;
        }

        public ApngState(@NotNull Apng apng, @IntRange(from=1L, to=0x7FFFFFFFL) int width, @IntRange(from=1L, to=0x7FFFFFFFL) int height, int sourceDensity, @NotNull Function0<Long> currentTimeProvider) {
            Intrinsics.checkNotNullParameter((Object)apng, (String)"apng");
            Intrinsics.checkNotNullParameter(currentTimeProvider, (String)"currentTimeProvider");
            this.apng = apng;
            this.width = width;
            this.height = height;
            this.sourceDensity = sourceDensity;
            this.currentTimeProvider = currentTimeProvider;
        }

        public /* synthetic */ ApngState(Apng apng, int n, int n2, int n3, Function0 function0, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 8) != 0) {
                n3 = 0;
            }
            if ((n4 & 0x10) != 0) {
                function0 = 1.INSTANCE;
            }
            this(apng, n, n2, n3, (Function0<Long>)function0);
        }

        public ApngState(@NotNull ApngState apngState) {
            Intrinsics.checkNotNullParameter((Object)((Object)apngState), (String)"apngState");
            this(apngState.apng.copy(), apngState.width, apngState.height, apngState.sourceDensity, apngState.currentTimeProvider);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J5\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0002\u0010\u000eJ7\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u00042\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0002\u0010\u0012J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0002\u0010\u0015J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\n\b\u0003\u0010\f\u001a\u0004\u0018\u00010\u00042\n\b\u0003\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0002\u0010\u0018J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0002\u0010\u001aJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001a\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u0004H\u0007J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u000bH\u0007J \u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/linecorp/apng/ApngDrawable$Companion;", "", "()V", "LOOP_FOREVER", "", "LOOP_INTRINSIC", "decode", "Lcom/linecorp/apng/ApngDrawable;", "assetManager", "Landroid/content/res/AssetManager;", "assetName", "", "width", "height", "(Landroid/content/res/AssetManager;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)Lcom/linecorp/apng/ApngDrawable;", "res", "Landroid/content/res/Resources;", "id", "(Landroid/content/res/Resources;ILjava/lang/Integer;Ljava/lang/Integer;)Lcom/linecorp/apng/ApngDrawable;", "file", "Ljava/io/File;", "(Ljava/io/File;Ljava/lang/Integer;Ljava/lang/Integer;)Lcom/linecorp/apng/ApngDrawable;", "stream", "Ljava/io/InputStream;", "(Ljava/io/InputStream;Ljava/lang/Integer;Ljava/lang/Integer;)Lcom/linecorp/apng/ApngDrawable;", "filePath", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)Lcom/linecorp/apng/ApngDrawable;", "isApng", "", "scaleFromDensity", "size", "sourceDensity", "targetDensity", "apng-drawable_release"})
    public static final class Companion {
        private final int scaleFromDensity(int size, int sourceDensity, int targetDensity) {
            return sourceDensity == 0 || targetDensity == 0 || sourceDensity == targetDensity ? size : (size * targetDensity + (sourceDensity >> 1)) / sourceDensity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        @NotNull
        public final ApngDrawable decode(@NotNull Resources res, @RawRes @DrawableRes int id, @Nullable Integer width, @Nullable Integer height) throws ApngException, Resources.NotFoundException, IOException {
            ApngDrawable apngDrawable;
            Intrinsics.checkNotNullParameter((Object)res, (String)"res");
            InputStream inputStream = res.openRawResource(id);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"res.openRawResource(id)");
            Closeable closeable = inputStream;
            int n = 8192;
            boolean bl = false;
            closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
            n = 0;
            bl = false;
            Throwable throwable = null;
            try {
                BufferedInputStream it = (BufferedInputStream)closeable;
                boolean bl2 = false;
                apngDrawable = Companion.decode(it, width, height);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return apngDrawable;
        }

        public static /* synthetic */ ApngDrawable decode$default(Companion companion, Resources resources, int n, Integer n2, Integer n3, int n4, Object object) throws ApngException, Resources.NotFoundException, IOException {
            if ((n4 & 4) != 0) {
                n2 = null;
            }
            if ((n4 & 8) != 0) {
                n3 = null;
            }
            return companion.decode(resources, n, n2, n3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        @NotNull
        public final ApngDrawable decode(@NotNull AssetManager assetManager, @NotNull String assetName, @Nullable Integer width, @Nullable Integer height) throws ApngException, IOException {
            ApngDrawable apngDrawable;
            Intrinsics.checkNotNullParameter((Object)assetManager, (String)"assetManager");
            Intrinsics.checkNotNullParameter((Object)assetName, (String)"assetName");
            InputStream inputStream = assetManager.open(assetName);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"assetManager.open(assetName)");
            Closeable closeable = inputStream;
            int n = 8192;
            boolean bl = false;
            closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
            n = 0;
            bl = false;
            Throwable throwable = null;
            try {
                BufferedInputStream it = (BufferedInputStream)closeable;
                boolean bl2 = false;
                apngDrawable = Companion.decode(it, width, height);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return apngDrawable;
        }

        public static /* synthetic */ ApngDrawable decode$default(Companion companion, AssetManager assetManager, String string, Integer n, Integer n2, int n3, Object object) throws ApngException, IOException {
            if ((n3 & 4) != 0) {
                n = null;
            }
            if ((n3 & 8) != 0) {
                n2 = null;
            }
            return companion.decode(assetManager, string, n, n2);
        }

        @WorkerThread
        @NotNull
        public final ApngDrawable decode(@NotNull String filePath, @Nullable Integer width, @Nullable Integer height) throws ApngException, FileNotFoundException, IOException {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            return this.decode(new File(filePath), width, height);
        }

        public static /* synthetic */ ApngDrawable decode$default(Companion companion, String string, Integer n, Integer n2, int n3, Object object) throws ApngException, FileNotFoundException, IOException {
            if ((n3 & 2) != 0) {
                n = null;
            }
            if ((n3 & 4) != 0) {
                n2 = null;
            }
            return companion.decode(string, n, n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        @NotNull
        public final ApngDrawable decode(@NotNull File file, @Nullable Integer width, @Nullable Integer height) throws ApngException, FileNotFoundException, IOException {
            ApngDrawable apngDrawable;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Object object = file;
            int n = 0;
            object = new FileInputStream((File)object);
            n = 8192;
            boolean bl = false;
            object = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
            n = 0;
            bl = false;
            Throwable throwable = null;
            try {
                BufferedInputStream it = (BufferedInputStream)object;
                boolean bl2 = false;
                apngDrawable = Companion.decode(it, width, height);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            return apngDrawable;
        }

        public static /* synthetic */ ApngDrawable decode$default(Companion companion, File file, Integer n, Integer n2, int n3, Object object) throws ApngException, FileNotFoundException, IOException {
            if ((n3 & 2) != 0) {
                n = null;
            }
            if ((n3 & 4) != 0) {
                n2 = null;
            }
            return companion.decode(file, n, n2);
        }

        @WorkerThread
        @NotNull
        public final ApngDrawable decode(@NotNull InputStream stream, @IntRange(from=1L, to=0x7FFFFFFFL) @Nullable Integer width, @IntRange(from=1L, to=0x7FFFFFFFL) @Nullable Integer height) throws ApngException {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            boolean bl = !(width == null ^ height == null);
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Can not specify only one side of size. width = " + width + ", height = " + height;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = width == null || width > 0;
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Can not specify 0 or negative as width value. width = " + width;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = height == null || height > 0;
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl6 = false;
                String string = "Can not specify 0 or negative as height value. height = " + height;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            int density = width == null && height == null ? 160 : 0;
            Apng apng = Apng.Companion.decode(stream);
            Integer n = width;
            Integer n2 = height;
            return new ApngDrawable(new ApngState(apng, n != null ? n.intValue() : apng.getWidth(), n2 != null ? n2.intValue() : apng.getHeight(), density, null, 16, null));
        }

        public static /* synthetic */ ApngDrawable decode$default(Companion companion, InputStream inputStream, Integer n, Integer n2, int n3, Object object) throws ApngException {
            if ((n3 & 2) != 0) {
                n = null;
            }
            if ((n3 & 4) != 0) {
                n2 = null;
            }
            return companion.decode(inputStream, n, n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public final boolean isApng(@NotNull Resources res, @RawRes @DrawableRes int id) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)res, (String)"res");
            try {
                boolean bl2;
                InputStream inputStream = res.openRawResource(id);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"res.openRawResource(id)");
                Closeable closeable = inputStream;
                int n = 8192;
                boolean bl3 = false;
                closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
                n = 0;
                bl3 = false;
                Throwable throwable = null;
                try {
                    BufferedInputStream it = (BufferedInputStream)closeable;
                    boolean bl4 = false;
                    bl2 = Companion.isApng(it);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                bl = bl2;
            }
            catch (Exception ignored) {
                bl = false;
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public final boolean isApng(@NotNull AssetManager assetManager, @NotNull String assetName) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)assetManager, (String)"assetManager");
            Intrinsics.checkNotNullParameter((Object)assetName, (String)"assetName");
            try {
                boolean bl2;
                InputStream inputStream = assetManager.open(assetName);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"assetManager.open(assetName)");
                Closeable closeable = inputStream;
                int n = 8192;
                boolean bl3 = false;
                closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
                n = 0;
                bl3 = false;
                Throwable throwable = null;
                try {
                    BufferedInputStream it = (BufferedInputStream)closeable;
                    boolean bl4 = false;
                    bl2 = Companion.isApng(it);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                bl = bl2;
            }
            catch (Exception ignored) {
                bl = false;
            }
            return bl;
        }

        @WorkerThread
        public final boolean isApng(@NotNull String filePath) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            try {
                bl = this.isApng(new File(filePath));
            }
            catch (Exception ignored) {
                bl = false;
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public final boolean isApng(@NotNull File file) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            try {
                boolean bl2;
                Object object = file;
                int n = 0;
                object = new FileInputStream((File)object);
                n = 8192;
                boolean bl3 = false;
                object = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
                n = 0;
                bl3 = false;
                Throwable throwable = null;
                try {
                    BufferedInputStream it = (BufferedInputStream)object;
                    boolean bl4 = false;
                    bl2 = Companion.isApng(it);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                bl = bl2;
            }
            catch (Exception ignored) {
                bl = false;
            }
            return bl;
        }

        @WorkerThread
        public final boolean isApng(@NotNull InputStream stream) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            try {
                bl = Apng.Companion.isApng(stream);
            }
            catch (ApngException ignored) {
                bl = false;
            }
            return bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

