/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.apng.decoder;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Build;
import android.os.Trace;
import androidx.annotation.IntRange;
import com.linecorp.apng.decoder.ApngDecoderJni;
import com.linecorp.apng.decoder.ApngException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 02\u00020\u0001:\u000201BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0001\u0010\t\u001a\u00020\u0003\u0012\b\b\u0001\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010#\u001a\u00020\u0000J0\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020-J\u0006\u0010.\u001a\u00020%J\u0006\u0010/\u001a\u00020%R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010 R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0013\u00a8\u00062"}, d2={"Lcom/linecorp/apng/decoder/Apng;", "", "id", "", "width", "height", "frameCount", "frameDurations", "", "loopCount", "allFrameByteCount", "", "(IIII[IIJ)V", "getAllFrameByteCount", "()J", "bitmap", "Landroid/graphics/Bitmap;", "byteCount", "getByteCount", "()I", "config", "Landroid/graphics/Bitmap$Config;", "getConfig", "()Landroid/graphics/Bitmap$Config;", "duration", "getDuration", "getFrameCount", "getFrameDurations", "()[I", "getHeight", "isRecycled", "", "()Z", "getLoopCount", "getWidth", "copy", "drawWithIndex", "", "frameIndex", "canvas", "Landroid/graphics/Canvas;", "src", "Landroid/graphics/Rect;", "dst", "paint", "Landroid/graphics/Paint;", "finalize", "recycle", "Companion", "DecodeResult", "apng-drawable_release"})
public final class Apng {
    private final Bitmap bitmap;
    @IntRange(from=0L, to=0x7FFFFFFFL)
    private final int duration;
    private final int id;
    private final int width;
    private final int height;
    private final int frameCount;
    @NotNull
    private final int[] frameDurations;
    private final int loopCount;
    private final long allFrameByteCount;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final int getByteCount() {
        return Build.VERSION.SDK_INT >= 19 ? this.bitmap.getAllocationByteCount() : this.bitmap.getRowBytes() * this.height;
    }

    public final int getDuration() {
        return this.duration;
    }

    public final boolean isRecycled() {
        return this.bitmap.isRecycled();
    }

    @NotNull
    public final Bitmap.Config getConfig() {
        Bitmap.Config config = this.bitmap.getConfig();
        Intrinsics.checkNotNullExpressionValue((Object)config, (String)"bitmap.config");
        return config;
    }

    public final void recycle() {
        ApngDecoderJni.recycle(this.id);
    }

    @NotNull
    public final Apng copy() {
        return Companion.copy(this);
    }

    public final void finalize() {
        this.recycle();
    }

    public final void drawWithIndex(int frameIndex, @NotNull Canvas canvas, @Nullable Rect src, @NotNull Rect dst, @NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        Trace.beginSection((String)"Apng#draw");
        ApngDecoderJni.draw(this.id, frameIndex, this.bitmap);
        Trace.endSection();
        canvas.drawBitmap(this.bitmap, src, dst, paint);
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getFrameCount() {
        return this.frameCount;
    }

    @NotNull
    public final int[] getFrameDurations() {
        return this.frameDurations;
    }

    public final int getLoopCount() {
        return this.loopCount;
    }

    public final long getAllFrameByteCount() {
        return this.allFrameByteCount;
    }

    public Apng(int id, int width, int height, @IntRange(from=1L, to=0x7FFFFFFFL) int frameCount, @NotNull int[] frameDurations, @IntRange(from=0L, to=0x7FFFFFFFL) int loopCount, @IntRange(from=0L, to=0x7FFFFFFFL) long allFrameByteCount) {
        Intrinsics.checkNotNullParameter((Object)frameDurations, (String)"frameDurations");
        this.id = id;
        this.width = width;
        this.height = height;
        this.frameCount = frameCount;
        this.frameDurations = frameDurations;
        this.loopCount = loopCount;
        this.allFrameByteCount = allFrameByteCount;
        Bitmap bitmap = Bitmap.createBitmap((int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"Bitmap.createBitmap(widt\u2026 Bitmap.Config.ARGB_8888)");
        this.bitmap = bitmap;
        Trace.beginSection((String)"Apng#draw");
        ApngDecoderJni.draw(this.id, 0, this.bitmap);
        Trace.endSection();
        this.duration = ArraysKt.sum((int[])this.frameDurations);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\f\"\u0004\b\u0017\u0010\u000eR\u001a\u0010\u0018\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\f\"\u0004\b\u001a\u0010\u000eR\u001a\u0010\u001b\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\f\"\u0004\b\u001d\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lcom/linecorp/apng/decoder/Apng$DecodeResult;", "", "()V", "allFrameByteCount", "", "getAllFrameByteCount", "()J", "setAllFrameByteCount", "(J)V", "frameCount", "", "getFrameCount", "()I", "setFrameCount", "(I)V", "frameDurations", "", "getFrameDurations", "()[I", "setFrameDurations", "([I)V", "height", "getHeight", "setHeight", "loopCount", "getLoopCount", "setLoopCount", "width", "getWidth", "setWidth", "apng-drawable_release"})
    public static final class DecodeResult {
        private int width;
        private int height;
        private int frameCount;
        private int loopCount;
        @NotNull
        private int[] frameDurations = new int[0];
        private long allFrameByteCount;

        public final int getWidth() {
            return this.width;
        }

        public final void setWidth(int n) {
            this.width = n;
        }

        public final int getHeight() {
            return this.height;
        }

        public final void setHeight(int n) {
            this.height = n;
        }

        public final int getFrameCount() {
            return this.frameCount;
        }

        public final void setFrameCount(int n) {
            this.frameCount = n;
        }

        public final int getLoopCount() {
            return this.loopCount;
        }

        public final void setLoopCount(int n) {
            this.loopCount = n;
        }

        @NotNull
        public final int[] getFrameDurations() {
            return this.frameDurations;
        }

        public final void setFrameDurations(@NotNull int[] nArray) {
            Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
            this.frameDurations = nArray;
        }

        public final long getAllFrameByteCount() {
            return this.allFrameByteCount;
        }

        public final void setAllFrameByteCount(long l) {
            this.allFrameByteCount = l;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/linecorp/apng/decoder/Apng$Companion;", "", "()V", "copy", "Lcom/linecorp/apng/decoder/Apng;", "apng", "decode", "stream", "Ljava/io/InputStream;", "isApng", "", "throwIfError", "", "resultCode", "", "apng-drawable_release"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Apng decode(@NotNull InputStream stream) throws ApngException {
            int n;
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            DecodeResult result = new DecodeResult();
            Trace.beginSection((String)"Apng#decode");
            try {
                n = ApngDecoderJni.decode(stream, result);
            }
            catch (Throwable e) {
                throw (Throwable)new ApngException(e);
            }
            finally {
                Trace.endSection();
            }
            int id = n;
            this.throwIfError(id);
            try {
                return new Apng(id, result.getWidth(), result.getHeight(), result.getFrameCount(), result.getFrameDurations(), result.getLoopCount(), result.getAllFrameByteCount());
            }
            catch (Throwable e) {
                throw (Throwable)new ApngException(e);
            }
        }

        public final boolean isApng(@NotNull InputStream stream) throws ApngException {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            try {
                bl = ApngDecoderJni.isApng(stream);
            }
            catch (Throwable e) {
                throw (Throwable)new ApngException(e);
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Apng copy(@NotNull Apng apng) throws ApngException {
            int n;
            Intrinsics.checkNotNullParameter((Object)apng, (String)"apng");
            DecodeResult result = new DecodeResult();
            Trace.beginSection((String)"Apng#copy");
            try {
                n = ApngDecoderJni.copy(apng.id, result);
            }
            catch (Throwable e) {
                throw (Throwable)new ApngException(e);
            }
            finally {
                Trace.endSection();
            }
            int id = n;
            this.throwIfError(id);
            try {
                return new Apng(id, result.getWidth(), result.getHeight(), result.getFrameCount(), result.getFrameDurations(), result.getLoopCount(), result.getAllFrameByteCount());
            }
            catch (Throwable e) {
                throw (Throwable)new ApngException(e);
            }
        }

        private final void throwIfError(int resultCode) throws ApngException {
            if (resultCode >= 0) {
                return;
            }
            throw (Throwable)new ApngException(ApngException.ErrorCode.Companion.fromErrorCode$apng_drawable_release(resultCode), null, 2, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

