/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.brave;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.brave.RequestContextCurrentTraceContext;
import com.linecorp.armeria.common.logging.RequestLogAvailability;
import com.linecorp.armeria.internal.brave.AsciiStringKeyFactory;
import com.linecorp.armeria.internal.brave.SpanContextUtil;
import com.linecorp.armeria.internal.brave.SpanTags;
import com.linecorp.armeria.internal.brave.TraceContextUtil;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingService;
import java.util.function.Function;

public final class BraveService
extends SimpleDecoratingService<HttpRequest, HttpResponse> {
    private final Tracer tracer;
    private final TraceContext.Extractor<HttpHeaders> extractor;

    public static Function<Service<HttpRequest, HttpResponse>, BraveService> newDecorator(Tracing tracing) {
        RequestContextCurrentTraceContext.ensureScopeUsesRequestContext(tracing);
        return service -> new BraveService((Service<HttpRequest, HttpResponse>)service, tracing);
    }

    private BraveService(Service<HttpRequest, HttpResponse> delegate, Tracing tracing) {
        super(delegate);
        this.tracer = tracing.tracer();
        this.extractor = tracing.propagationFactory().create((Propagation.KeyFactory)AsciiStringKeyFactory.INSTANCE).extractor((rec$, x$0) -> ((HttpHeaders)rec$).get(x$0));
    }

    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        Span span;
        TraceContextOrSamplingFlags contextOrFlags = this.extractor.extract((Object)req.headers());
        Span span2 = span = contextOrFlags.context() != null ? this.tracer.joinSpan(contextOrFlags.context()) : this.tracer.nextSpan(contextOrFlags);
        if (span.isNoop()) {
            return (HttpResponse)this.delegate().serve(ctx, (Request)req);
        }
        String method = ctx.method().name();
        span.kind(Span.Kind.SERVER).name(method);
        ctx.log().addListener(log -> SpanContextUtil.startSpan(span, log), RequestLogAvailability.REQUEST_START);
        ctx.onChild(TraceContextUtil::copy);
        ctx.log().addListener(log -> {
            SpanTags.logWireReceive(span, log.requestFirstBytesTransferredTimeNanos(), log);
            if (log.isAvailable(RequestLogAvailability.RESPONSE_FIRST_BYTES_TRANSFERRED)) {
                SpanTags.logWireSend(span, log.responseFirstBytesTransferredTimeNanos(), log);
            }
            SpanContextUtil.closeSpan(span, log);
        }, RequestLogAvailability.COMPLETE);
        try (Tracer.SpanInScope ignored = this.tracer.withSpanInScope(span);){
            HttpResponse httpResponse = (HttpResponse)this.delegate().serve(ctx, (Request)req);
            return httpResponse;
        }
    }
}

