/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.brave;

import brave.SpanCustomizer;
import brave.http.HttpAdapter;
import brave.http.HttpClientParser;
import com.linecorp.armeria.client.brave.ArmeriaHttpClientAdapter;
import com.linecorp.armeria.common.logging.RequestLog;
import java.net.SocketAddress;

final class ArmeriaHttpClientParser
extends HttpClientParser {
    private static final ArmeriaHttpClientParser INSTANCE = new ArmeriaHttpClientParser();

    static ArmeriaHttpClientParser get() {
        return INSTANCE;
    }

    private ArmeriaHttpClientParser() {
    }

    public <T> void response(HttpAdapter<?, T> rawAdapter, T res, Throwable error, SpanCustomizer customizer) {
        super.response(rawAdapter, res, error, customizer);
        if (res instanceof RequestLog && rawAdapter instanceof ArmeriaHttpClientAdapter) {
            String rpcMethod;
            SocketAddress laddr;
            SocketAddress raddr;
            RequestLog requestLog = (RequestLog)res;
            ArmeriaHttpClientAdapter adapter = (ArmeriaHttpClientAdapter)rawAdapter;
            customizer.tag("http.host", adapter.authority(requestLog)).tag("http.url", adapter.url(requestLog)).tag("http.protocol", adapter.protocol(requestLog));
            String serFmt = adapter.serializationFormat(requestLog);
            if (serFmt != null) {
                customizer.tag("http.serfmt", serFmt);
            }
            if ((raddr = requestLog.context().remoteAddress()) != null) {
                customizer.tag("address.remote", raddr.toString());
            }
            if ((laddr = requestLog.context().localAddress()) != null) {
                customizer.tag("address.local", laddr.toString());
            }
            if ((rpcMethod = adapter.rpcMethod(requestLog)) != null) {
                customizer.name(rpcMethod);
            }
        }
    }
}

