/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.brave;

import brave.Span;
import com.linecorp.armeria.common.RpcRequest;
import com.linecorp.armeria.common.Scheme;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogAvailability;
import com.linecorp.armeria.internal.brave.SpanContextUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.annotation.Nullable;

public final class SpanTags {
    private static final String WIRE_SEND_ANNOTATION = "ws";
    private static final String WIRE_RECEIVE_ANNOTATION = "wr";
    public static final String TAG_HTTP_HOST = "http.host";
    public static final String TAG_HTTP_METHOD = "http.method";
    public static final String TAG_HTTP_PATH = "http.path";
    public static final String TAG_HTTP_URL = "http.url";
    public static final String TAG_HTTP_STATUS_CODE = "http.status_code";
    public static final String TAG_HTTP_PROTOCOL = "http.protocol";
    public static final String TAG_HTTP_SERIALIZATION_FORMAT = "http.serfmt";
    public static final String TAG_ERROR = "error";
    public static final String TAG_ADDRESS_REMOTE = "address.remote";
    public static final String TAG_ADDRESS_LOCAL = "address.local";

    public static void addTags(Span span, RequestLog log) {
        Object requestContent;
        SocketAddress laddr;
        SocketAddress raddr;
        Throwable responseCause;
        Scheme scheme = log.scheme();
        String authority = log.requestHeaders().authority();
        String path = log.path();
        assert (authority != null);
        span.tag(TAG_HTTP_HOST, authority).tag(TAG_HTTP_METHOD, log.method().name()).tag(TAG_HTTP_PATH, path).tag(TAG_HTTP_URL, SpanTags.generateUrl(log)).tag(TAG_HTTP_STATUS_CODE, log.status().codeAsText()).tag(TAG_HTTP_PROTOCOL, scheme.sessionProtocol().uriText());
        SerializationFormat serFmt = scheme.serializationFormat();
        if (serFmt != SerializationFormat.NONE) {
            span.tag(TAG_HTTP_SERIALIZATION_FORMAT, serFmt.uriText());
        }
        if ((responseCause = log.responseCause()) != null) {
            span.tag(TAG_ERROR, responseCause.toString());
        }
        if ((raddr = log.context().remoteAddress()) != null) {
            span.tag(TAG_ADDRESS_REMOTE, raddr.toString());
        }
        if ((laddr = log.context().localAddress()) != null) {
            span.tag(TAG_ADDRESS_LOCAL, laddr.toString());
        }
        if ((requestContent = log.requestContent()) instanceof RpcRequest) {
            span.name(((RpcRequest)requestContent).method());
        }
    }

    @Nullable
    public static String generateUrl(RequestLog requestLog) {
        if (!requestLog.isAvailable(RequestLogAvailability.SCHEME) || !requestLog.isAvailable(RequestLogAvailability.REQUEST_HEADERS)) {
            return null;
        }
        Scheme scheme = requestLog.scheme();
        String authority = requestLog.authority();
        String path = requestLog.path();
        String query = requestLog.query();
        SessionProtocol sessionProtocol = scheme.sessionProtocol();
        String uriScheme = SessionProtocol.httpValues().contains(sessionProtocol) ? "http://" : (SessionProtocol.httpsValues().contains(sessionProtocol) ? "https://" : sessionProtocol.uriText() + "://");
        StringBuilder uriBuilder = new StringBuilder(uriScheme.length() + authority.length() + path.length() + (query != null ? query.length() + 1 : 0));
        uriBuilder.append(uriScheme).append(authority).append(path);
        if (query != null) {
            uriBuilder.append('?').append(query);
        }
        return uriBuilder.toString();
    }

    public static void logWireSend(Span span, long wireSendTimeNanos, RequestLog requestLog) {
        span.annotate(SpanContextUtil.wallTimeMicros(requestLog, wireSendTimeNanos), WIRE_SEND_ANNOTATION);
    }

    public static void logWireReceive(Span span, long wireSendTimeNanos, RequestLog requestLog) {
        span.annotate(SpanContextUtil.wallTimeMicros(requestLog, wireSendTimeNanos), WIRE_RECEIVE_ANNOTATION);
    }

    public static boolean updateRemoteEndpoint(Span span, RequestLog log) {
        int port;
        InetAddress address;
        SocketAddress remoteAddress = log.context().remoteAddress();
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress socketAddress = (InetSocketAddress)remoteAddress;
            address = socketAddress.getAddress();
            port = socketAddress.getPort();
        } else {
            address = null;
            port = 0;
        }
        if (address != null) {
            return span.remoteIpAndPort(address.getHostAddress(), port);
        }
        return false;
    }

    private SpanTags() {
    }
}

