/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.brave;

import brave.Span;
import brave.http.HttpServerAdapter;
import com.linecorp.armeria.common.RpcRequest;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogAvailability;
import com.linecorp.armeria.internal.brave.SpanTags;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.ServiceRequestContext;
import java.util.List;
import javax.annotation.Nullable;

final class ArmeriaHttpServerAdapter
extends HttpServerAdapter<RequestLog, RequestLog> {
    private static final ArmeriaHttpServerAdapter INSTANCE = new ArmeriaHttpServerAdapter();

    static ArmeriaHttpServerAdapter get() {
        return INSTANCE;
    }

    private ArmeriaHttpServerAdapter() {
    }

    public String method(RequestLog requestLog) {
        return requestLog.method().name();
    }

    public String path(RequestLog requestLog) {
        return requestLog.path();
    }

    @Nullable
    public String url(RequestLog requestLog) {
        return SpanTags.generateUrl(requestLog);
    }

    @Nullable
    public String requestHeader(RequestLog requestLog, String name) {
        if (!requestLog.isAvailable(RequestLogAvailability.REQUEST_HEADERS)) {
            return null;
        }
        return requestLog.requestHeaders().get((CharSequence)name);
    }

    @Nullable
    public Integer statusCode(RequestLog requestLog) {
        int result = this.statusCodeAsInt(requestLog);
        return result != 0 ? Integer.valueOf(result) : null;
    }

    public int statusCodeAsInt(RequestLog requestLog) {
        if (!requestLog.isAvailable(RequestLogAvailability.RESPONSE_HEADERS)) {
            return 0;
        }
        return requestLog.status().code();
    }

    public String methodFromResponse(RequestLog requestLog) {
        return requestLog.method().name();
    }

    @Nullable
    public String route(RequestLog response) {
        assert (response.context() instanceof ServiceRequestContext);
        Route route = ((ServiceRequestContext)response.context()).route();
        List paths = route.paths();
        switch (route.pathType()) {
            case EXACT: 
            case PREFIX: 
            case PARAMETERIZED: {
                return (String)paths.get(1);
            }
            case REGEX: {
                return (String)paths.get(paths.size() - 1);
            }
            case REGEX_WITH_PREFIX: {
                return (String)paths.get(1) + (String)paths.get(0);
            }
        }
        return null;
    }

    @Nullable
    public String authority(RequestLog requestLog) {
        if (!requestLog.isAvailable(RequestLogAvailability.REQUEST_HEADERS)) {
            return null;
        }
        return requestLog.authority();
    }

    @Nullable
    public String protocol(RequestLog requestLog) {
        if (!requestLog.isAvailable(RequestLogAvailability.SCHEME)) {
            return null;
        }
        return requestLog.scheme().sessionProtocol().uriText();
    }

    @Nullable
    public String serializationFormat(RequestLog requestLog) {
        if (!requestLog.isAvailable(RequestLogAvailability.SCHEME)) {
            return null;
        }
        SerializationFormat serFmt = requestLog.scheme().serializationFormat();
        return serFmt == SerializationFormat.NONE ? null : serFmt.uriText();
    }

    @Nullable
    public String rpcMethod(RequestLog requestLog) {
        if (!requestLog.isAvailable(RequestLogAvailability.REQUEST_CONTENT)) {
            return null;
        }
        Object requestContent = requestLog.requestContent();
        return requestContent instanceof RpcRequest ? ((RpcRequest)requestContent).method() : null;
    }

    public boolean parseClientIpAndPort(RequestLog requestLog, Span span) {
        if (this.parseClientIpFromXForwardedFor(requestLog, span)) {
            return true;
        }
        return SpanTags.updateRemoteEndpoint(span, requestLog);
    }
}

