/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.brave;

import brave.SpanCustomizer;
import brave.http.HttpAdapter;
import brave.http.HttpServerParser;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.server.brave.ArmeriaHttpServerAdapter;
import java.net.SocketAddress;

final class ArmeriaHttpServerParser
extends HttpServerParser {
    private static final ArmeriaHttpServerParser INSTANCE = new ArmeriaHttpServerParser();

    static ArmeriaHttpServerParser get() {
        return INSTANCE;
    }

    private ArmeriaHttpServerParser() {
    }

    public <T> void response(HttpAdapter<?, T> rawAdapter, T res, Throwable error, SpanCustomizer customizer) {
        super.response(rawAdapter, res, error, customizer);
        if (res instanceof RequestLog && rawAdapter instanceof ArmeriaHttpServerAdapter) {
            String rpcMethod;
            SocketAddress laddr;
            SocketAddress raddr;
            RequestLog requestLog = (RequestLog)res;
            ArmeriaHttpServerAdapter adapter = (ArmeriaHttpServerAdapter)rawAdapter;
            customizer.tag("http.host", adapter.authority(requestLog)).tag("http.url", adapter.url(requestLog)).tag("http.protocol", adapter.protocol(requestLog));
            String serFmt = adapter.serializationFormat(requestLog);
            if (serFmt != null) {
                customizer.tag("http.serfmt", serFmt);
            }
            if ((raddr = requestLog.context().remoteAddress()) != null) {
                customizer.tag("address.remote", raddr.toString());
            }
            if ((laddr = requestLog.context().localAddress()) != null) {
                customizer.tag("address.local", laddr.toString());
            }
            if ((rpcMethod = adapter.rpcMethod(requestLog)) != null) {
                customizer.name(rpcMethod);
            }
        }
    }
}

