/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.brave;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.http.HttpAdapter;
import brave.http.HttpServerAdapter;
import brave.http.HttpServerHandler;
import brave.http.HttpServerParser;
import brave.http.HttpTracing;
import brave.propagation.CurrentTraceContext;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.brave.RequestContextCurrentTraceContext;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogAvailability;
import com.linecorp.armeria.internal.brave.AsciiStringKeyFactory;
import com.linecorp.armeria.internal.brave.SpanContextUtil;
import com.linecorp.armeria.internal.brave.SpanTags;
import com.linecorp.armeria.internal.brave.TraceContextUtil;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingHttpService;
import com.linecorp.armeria.server.brave.ArmeriaHttpServerAdapter;
import com.linecorp.armeria.server.brave.ArmeriaHttpServerParser;
import java.util.function.Function;

public final class BraveService
extends SimpleDecoratingHttpService {
    private final Tracer tracer;
    private final TraceContext.Extractor<HttpHeaders> extractor;
    private final HttpServerHandler<RequestLog, RequestLog> handler;
    private final CurrentTraceContext currentTraceContext;
    private final ArmeriaHttpServerAdapter adapter;
    private final HttpServerParser serverParser;

    public static Function<Service<HttpRequest, HttpResponse>, BraveService> newDecorator(Tracing tracing) {
        return BraveService.newDecorator(HttpTracing.newBuilder((Tracing)tracing).serverParser((HttpServerParser)ArmeriaHttpServerParser.get()).build());
    }

    public static Function<Service<HttpRequest, HttpResponse>, BraveService> newDecorator(HttpTracing httpTracing) {
        RequestContextCurrentTraceContext.ensureScopeUsesRequestContext(httpTracing.tracing());
        return service -> new BraveService((Service<HttpRequest, HttpResponse>)service, httpTracing);
    }

    private BraveService(Service<HttpRequest, HttpResponse> delegate, HttpTracing httpTracing) {
        super(delegate);
        this.currentTraceContext = httpTracing.tracing().currentTraceContext();
        this.tracer = httpTracing.tracing().tracer();
        this.serverParser = httpTracing.serverParser();
        this.adapter = ArmeriaHttpServerAdapter.get();
        this.handler = HttpServerHandler.create((HttpTracing)httpTracing, (HttpServerAdapter)this.adapter);
        this.extractor = httpTracing.tracing().propagationFactory().create((Propagation.KeyFactory)AsciiStringKeyFactory.INSTANCE).extractor((rec$, x$0) -> ((HttpHeaders)rec$).get(x$0));
    }

    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        Span span = this.handler.handleReceive(this.extractor, (Object)req.headers(), (Object)ctx.log());
        ctx.onChild(TraceContextUtil::copy);
        if (span.isNoop()) {
            try (Tracer.SpanInScope ignored = this.tracer.withSpanInScope(span);){
                HttpResponse httpResponse = (HttpResponse)this.delegate().serve(ctx, (Request)req);
                return httpResponse;
            }
        }
        ctx.log().addListener(log -> SpanContextUtil.startSpan(span, log), RequestLogAvailability.REQUEST_START);
        ctx.log().addListener(log -> {
            SpanTags.logWireReceive(span, log.requestFirstBytesTransferredTimeNanos(), log);
            if (log.isAvailable(RequestLogAvailability.RESPONSE_FIRST_BYTES_TRANSFERRED)) {
                SpanTags.logWireSend(span, log.responseFirstBytesTransferredTimeNanos(), log);
            }
            this.handleFinish(log, span);
        }, RequestLogAvailability.COMPLETE);
        try (Tracer.SpanInScope ignored = this.tracer.withSpanInScope(span);){
            HttpResponse httpResponse = (HttpResponse)this.delegate().serve(ctx, (Request)req);
            return httpResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFinish(RequestLog requestLog, Span span) {
        if (span.isNoop()) {
            return;
        }
        try (CurrentTraceContext.Scope ws = this.currentTraceContext.maybeScope(span.context());){
            this.serverParser.response((HttpAdapter)this.adapter, (Object)requestLog, requestLog.responseCause(), span.customizer());
        }
        finally {
            this.finishInNullScope(span, requestLog);
        }
    }

    private void finishInNullScope(Span span, RequestLog requestLog) {
        try (CurrentTraceContext.Scope ws = this.currentTraceContext.maybeScope(null);){
            span.finish(SpanContextUtil.wallTimeMicros(requestLog, requestLog.responseEndTimeNanos()));
        }
    }
}

