/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.brave;

import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.brave.RequestContextCurrentTraceContextBuilder;
import com.linecorp.armeria.internal.common.brave.TraceContextUtil;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestContextCurrentTraceContext
extends CurrentTraceContext {
    private static final RequestContextCurrentTraceContext DEFAULT = RequestContextCurrentTraceContext.builder().build();
    private static final Logger logger = LoggerFactory.getLogger(RequestContextCurrentTraceContext.class);
    private static final ThreadLocal<TraceContext> THREAD_LOCAL_CONTEXT = new ThreadLocal();
    private static final ThreadLocal<Boolean> THREAD_NOT_REQUEST_THREAD = new ThreadLocal();
    private static final CurrentTraceContext.Scope INITIAL_REQUEST_SCOPE = new CurrentTraceContext.Scope(){

        public void close() {
        }

        public String toString() {
            return "InitialRequestScope";
        }
    };
    private final List<Pattern> nonRequestThreadPatterns;

    public static RequestContextCurrentTraceContext ofDefault() {
        return DEFAULT;
    }

    public static RequestContextCurrentTraceContextBuilder builder() {
        return new RequestContextCurrentTraceContextBuilder();
    }

    public static void setCurrentThreadNotRequestThread(boolean value) {
        if (value) {
            THREAD_NOT_REQUEST_THREAD.set(true);
        } else {
            THREAD_NOT_REQUEST_THREAD.remove();
        }
    }

    RequestContextCurrentTraceContext(CurrentTraceContext.Builder builder, List<Pattern> nonRequestThreadPatterns) {
        super(builder);
        this.nonRequestThreadPatterns = nonRequestThreadPatterns;
    }

    @Nullable
    public TraceContext get() {
        RequestContext ctx = this.getRequestContextOrWarnOnce();
        if (ctx == null) {
            return THREAD_LOCAL_CONTEXT.get();
        }
        if (ctx.eventLoop().inEventLoop()) {
            return TraceContextUtil.traceContext(ctx);
        }
        TraceContext threadLocalContext = THREAD_LOCAL_CONTEXT.get();
        if (threadLocalContext != null) {
            return threadLocalContext;
        }
        return TraceContextUtil.traceContext(ctx);
    }

    public CurrentTraceContext.Scope newScope(@Nullable TraceContext currentSpan) {
        if (currentSpan != null && TraceContextUtil.PingPongExtra.maybeSetPong(currentSpan)) {
            return CurrentTraceContext.Scope.NOOP;
        }
        RequestContext ctx = this.getRequestContextOrWarnOnce();
        if (ctx != null && ctx.eventLoop().inEventLoop()) {
            return this.createScopeForRequestThread(ctx, currentSpan);
        }
        return this.createScopeForNonRequestThread(currentSpan);
    }

    private CurrentTraceContext.Scope createScopeForRequestThread(RequestContext ctx, @Nullable TraceContext currentSpan) {
        final TraceContext previous = TraceContextUtil.traceContext(ctx);
        TraceContextUtil.setTraceContext(ctx, currentSpan);
        if (previous == null) {
            return this.decorateScope(currentSpan, INITIAL_REQUEST_SCOPE);
        }
        class RequestContextTraceContextScope
        implements CurrentTraceContext.Scope {
            RequestContextTraceContextScope() {
            }

            public void close() {
                RequestContext ctx = RequestContextCurrentTraceContext.this.getRequestContextOrWarnOnce();
                if (ctx != null) {
                    TraceContextUtil.setTraceContext(ctx, previous);
                }
            }

            public String toString() {
                return "RequestContextTraceContextScope";
            }
        }
        return this.decorateScope(currentSpan, new RequestContextTraceContextScope());
    }

    private CurrentTraceContext.Scope createScopeForNonRequestThread(@Nullable TraceContext currentSpan) {
        final TraceContext previous = THREAD_LOCAL_CONTEXT.get();
        THREAD_LOCAL_CONTEXT.set(currentSpan);
        class ThreadLocalScope
        implements CurrentTraceContext.Scope {
            ThreadLocalScope() {
            }

            public void close() {
                THREAD_LOCAL_CONTEXT.set(previous);
            }

            public String toString() {
                return "ThreadLocalScope";
            }
        }
        return this.decorateScope(currentSpan, new ThreadLocalScope());
    }

    @Nullable
    private RequestContext getRequestContextOrWarnOnce() {
        if (Boolean.TRUE.equals(THREAD_NOT_REQUEST_THREAD.get())) {
            return null;
        }
        if (!this.nonRequestThreadPatterns.isEmpty()) {
            String threadName = Thread.currentThread().getName();
            for (Pattern pattern : this.nonRequestThreadPatterns) {
                if (!pattern.matcher(threadName).find()) continue;
                RequestContextCurrentTraceContext.setCurrentThreadNotRequestThread(true);
                return null;
            }
        }
        return (RequestContext)RequestContext.mapCurrent(Function.identity(), (Supplier)LogRequestContextWarningOnce.INSTANCE);
    }

    private static enum LogRequestContextWarningOnce implements Supplier<RequestContext>
    {
        INSTANCE;


        @Override
        @Nullable
        public RequestContext get() {
            ClassLoaderHack.loadMe();
            return null;
        }

        private static final class ClassLoaderHack {
            private ClassLoaderHack() {
            }

            static void loadMe() {
            }

            static {
                logger.warn("Attempted to propagate trace context, but no request context available. Did you forget to use RequestContext.contextAwareExecutor() or RequestContext.makeContextAware()?", (Throwable)new NoRequestContextException());
            }
        }

        private static final class NoRequestContextException
        extends RuntimeException {
            private static final long serialVersionUID = 2804189311774982052L;

            private NoRequestContextException() {
            }
        }
    }
}

