/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.brave;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.RequestHeadersBuilder;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogAccess;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.internal.common.brave.SpanContextUtil;

final class ClientRequestContextAdapter {
    static brave.http.HttpClientRequest asHttpClientRequest(ClientRequestContext ctx, RequestHeadersBuilder headersBuilder) {
        return new HttpClientRequest(ctx, headersBuilder);
    }

    static brave.http.HttpClientResponse asHttpClientResponse(RequestLog log, brave.http.HttpClientRequest request) {
        return new HttpClientResponse(log, request);
    }

    static String protocol(RequestLog requestLog) {
        return requestLog.scheme().sessionProtocol().uriText();
    }

    @Nullable
    static String serializationFormat(RequestLog requestLog) {
        SerializationFormat serFmt = requestLog.scheme().serializationFormat();
        return serFmt == SerializationFormat.NONE ? null : serFmt.uriText();
    }

    private ClientRequestContextAdapter() {
    }

    private static final class HttpClientRequest
    extends brave.http.HttpClientRequest {
        private final ClientRequestContext ctx;
        private final RequestHeadersBuilder headersBuilder;

        HttpClientRequest(ClientRequestContext ctx, RequestHeadersBuilder headersBuilder) {
            this.ctx = ctx;
            this.headersBuilder = headersBuilder;
        }

        public ClientRequestContext unwrap() {
            return this.ctx;
        }

        public String method() {
            return this.ctx.method().name();
        }

        public String path() {
            return this.ctx.path();
        }

        @Nullable
        public String url() {
            HttpRequest req = this.ctx.request();
            return req != null ? req.uri().toString() : null;
        }

        @Nullable
        public String header(String name) {
            HttpRequest req = this.ctx.request();
            return req != null ? req.headers().get((CharSequence)name) : null;
        }

        public void header(String name, String value) {
            this.headersBuilder.set((CharSequence)name, value);
        }

        public long startTimestamp() {
            RequestLogAccess logAccess = this.ctx.log();
            if (logAccess.isAvailable(RequestLogProperty.REQUEST_START_TIME)) {
                return logAccess.partial().requestStartTimeMicros();
            }
            return 0L;
        }
    }

    private static final class HttpClientResponse
    extends brave.http.HttpClientResponse {
        private final RequestLog log;
        private final brave.http.HttpClientRequest request;

        HttpClientResponse(RequestLog log, brave.http.HttpClientRequest request) {
            assert (log.isComplete()) : log;
            this.log = log;
            this.request = request;
        }

        public ClientRequestContext unwrap() {
            return (ClientRequestContext)this.log.context();
        }

        public brave.http.HttpClientRequest request() {
            return this.request;
        }

        @Nullable
        public Throwable error() {
            return this.log.responseCause();
        }

        public int statusCode() {
            return this.log.responseHeaders().status().code();
        }

        public long finishTimestamp() {
            return SpanContextUtil.wallTimeMicros(this.log, this.log.responseEndTimeNanos());
        }
    }
}

