/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.brave;

import brave.Tracing;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.brave.RequestContextCurrentTraceContext;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import io.netty.util.AttributeKey;
import java.util.Objects;

public final class TraceContextUtil {
    private static final AttributeKey<TraceContext> TRACE_CONTEXT_KEY = AttributeKey.valueOf(TraceContextUtil.class, (String)"TRACE_CONTEXT");

    @Nullable
    public static TraceContext traceContext(RequestContext ctx) {
        return (TraceContext)ctx.attr(TRACE_CONTEXT_KEY);
    }

    public static void setTraceContext(RequestContext ctx, TraceContext traceContext) {
        ctx.setAttr(TRACE_CONTEXT_KEY, (Object)traceContext);
    }

    public static void ensureScopeUsesRequestContext(Tracing tracing) {
        boolean scopeUsesRequestContext;
        Objects.requireNonNull(tracing, "tracing");
        PingPongExtra extra = new PingPongExtra();
        TraceContext dummyContext = TraceContext.newBuilder().traceId(1L).spanId(1L).addExtra((Object)extra).build();
        try (CurrentTraceContext.Scope scope = tracing.currentTraceContext().newScope(dummyContext);){
            scopeUsesRequestContext = extra.isPong();
        }
        if (!scopeUsesRequestContext) {
            throw new IllegalStateException("Tracing.currentTraceContext is not a " + RequestContextCurrentTraceContext.class.getSimpleName() + " scope. Please call Tracing.Builder.currentTraceContext(" + RequestContextCurrentTraceContext.class.getSimpleName() + ".ofDefault()).");
        }
    }

    private TraceContextUtil() {
    }

    @VisibleForTesting
    public static final class PingPongExtra {
        private boolean pong;

        public static boolean maybeSetPong(TraceContext context) {
            Object extra;
            if (context.extra().size() == 1 && (extra = context.extra().get(0)) instanceof PingPongExtra) {
                ((PingPongExtra)extra).pong = true;
                return true;
            }
            return false;
        }

        public boolean isPong() {
            return this.pong;
        }
    }
}

