/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.brave;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.http.HttpRequestParser;
import brave.http.HttpResponseParser;
import brave.http.HttpServerHandler;
import brave.http.HttpServerRequest;
import brave.http.HttpServerResponse;
import brave.http.HttpTracing;
import brave.propagation.CurrentTraceContext;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.brave.RequestContextCurrentTraceContext;
import com.linecorp.armeria.internal.common.brave.SpanTags;
import com.linecorp.armeria.internal.common.brave.TraceContextUtil;
import com.linecorp.armeria.server.DefaultServiceRequestContext;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingHttpService;
import com.linecorp.armeria.server.TransientServiceOption;
import com.linecorp.armeria.server.brave.ArmeriaHttpServerParser;
import com.linecorp.armeria.server.brave.ServiceRequestContextAdapter;
import java.util.function.Function;

public final class BraveService
extends SimpleDecoratingHttpService {
    private static final CurrentTraceContext.Scope SERVICE_REQUEST_DECORATING_SCOPE = new CurrentTraceContext.Scope(){

        public void close() {
        }

        public String toString() {
            return "ServiceRequestDecoratingScope";
        }
    };
    private final Tracer tracer;
    private final HttpServerHandler<HttpServerRequest, HttpServerResponse> handler;
    private final RequestContextCurrentTraceContext currentTraceContext;

    public static Function<? super HttpService, BraveService> newDecorator(Tracing tracing) {
        return BraveService.newDecorator(HttpTracing.newBuilder((Tracing)tracing).serverRequestParser((HttpRequestParser)ArmeriaHttpServerParser.get()).serverResponseParser((HttpResponseParser)ArmeriaHttpServerParser.get()).build());
    }

    public static Function<? super HttpService, BraveService> newDecorator(HttpTracing httpTracing) {
        TraceContextUtil.ensureScopeUsesRequestContext(httpTracing.tracing());
        return service -> new BraveService((HttpService)service, httpTracing);
    }

    private BraveService(HttpService delegate, HttpTracing httpTracing) {
        super(delegate);
        Tracing tracing = httpTracing.tracing();
        this.tracer = tracing.tracer();
        this.handler = HttpServerHandler.create((HttpTracing)httpTracing);
        this.currentTraceContext = (RequestContextCurrentTraceContext)tracing.currentTraceContext();
    }

    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        if (!ctx.config().transientServiceOptions().contains(TransientServiceOption.WITH_TRACING)) {
            return (HttpResponse)((Service)this.unwrap()).serve(ctx, (Request)req);
        }
        HttpServerRequest braveReq = ServiceRequestContextAdapter.asHttpServerRequest(ctx);
        Span span = this.handler.handleReceive(braveReq);
        if (this.currentTraceContext.scopeDecoratorAdded() && !span.isNoop() && ctx instanceof DefaultServiceRequestContext) {
            DefaultServiceRequestContext defaultCtx = (DefaultServiceRequestContext)ctx;
            defaultCtx.hook(() -> {
                CurrentTraceContext.Scope scope = this.currentTraceContext.decorateScope(span.context(), SERVICE_REQUEST_DECORATING_SCOPE);
                return () -> ((CurrentTraceContext.Scope)scope).close();
            });
        }
        this.maybeAddTagsToSpan(ctx, braveReq, span);
        try (Tracer.SpanInScope ignored = this.tracer.withSpanInScope(span);){
            HttpResponse httpResponse = (HttpResponse)((Service)this.unwrap()).serve(ctx, (Request)req);
            return httpResponse;
        }
    }

    private void maybeAddTagsToSpan(ServiceRequestContext ctx, HttpServerRequest braveReq, Span span) {
        if (span.isNoop()) {
            return;
        }
        ctx.log().whenComplete().thenAccept(log -> {
            span.start(log.requestStartTimeMicros());
            Long wireReceiveTimeNanos = log.requestFirstBytesTransferredTimeNanos();
            assert (wireReceiveTimeNanos != null);
            SpanTags.logWireReceive(span, wireReceiveTimeNanos, log);
            Long wireSendTimeNanos = log.responseFirstBytesTransferredTimeNanos();
            if (wireSendTimeNanos != null) {
                SpanTags.logWireSend(span, wireSendTimeNanos, log);
            }
            HttpServerResponse braveRes = ServiceRequestContextAdapter.asHttpServerResponse(log, braveReq);
            this.handler.handleSend(braveRes, span);
        });
    }
}

