/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.brave;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.http.HttpClientHandler;
import brave.http.HttpClientRequest;
import brave.http.HttpClientResponse;
import brave.http.HttpRequestParser;
import brave.http.HttpResponseParser;
import brave.http.HttpTracing;
import brave.propagation.CurrentTraceContext;
import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.DefaultClientRequestContext;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.SimpleDecoratingHttpClient;
import com.linecorp.armeria.client.brave.ArmeriaHttpClientParser;
import com.linecorp.armeria.client.brave.ClientRequestContextAdapter;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.RequestHeadersBuilder;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.brave.RequestContextCurrentTraceContext;
import com.linecorp.armeria.common.logging.ClientConnectionTimings;
import com.linecorp.armeria.internal.common.brave.SpanTags;
import com.linecorp.armeria.internal.common.brave.TraceContextUtil;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BraveClient
extends SimpleDecoratingHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(BraveClient.class);
    private final Tracer tracer;
    private final HttpClientHandler<HttpClientRequest, HttpClientResponse> handler;
    @Nullable
    private final RequestContextCurrentTraceContext currentTraceContext;

    public static Function<? super HttpClient, BraveClient> newDecorator(Tracing tracing) {
        return BraveClient.newDecorator(tracing, null);
    }

    public static Function<? super HttpClient, BraveClient> newDecorator(Tracing tracing, @Nullable String remoteServiceName) {
        HttpTracing httpTracing = HttpTracing.newBuilder((Tracing)tracing).clientRequestParser((HttpRequestParser)ArmeriaHttpClientParser.get()).clientResponseParser((HttpResponseParser)ArmeriaHttpClientParser.get()).build();
        if (remoteServiceName != null) {
            httpTracing = httpTracing.clientOf(remoteServiceName);
        }
        return BraveClient.newDecorator(httpTracing);
    }

    public static Function<? super HttpClient, BraveClient> newDecorator(HttpTracing httpTracing) {
        try {
            TraceContextUtil.ensureScopeUsesRequestContext(httpTracing.tracing());
        }
        catch (IllegalStateException e) {
            logger.warn("{} - it is appropriate to ignore this warning if this client is not being used inside an Armeria server (e.g., this is a normal spring-mvc tomcat server).", (Object)e.getMessage());
        }
        return delegate -> new BraveClient((HttpClient)delegate, httpTracing);
    }

    private BraveClient(HttpClient delegate, HttpTracing httpTracing) {
        super(delegate);
        Tracing tracing = httpTracing.tracing();
        this.tracer = tracing.tracer();
        this.handler = HttpClientHandler.create((HttpTracing)httpTracing);
        CurrentTraceContext currentTraceContext = tracing.currentTraceContext();
        this.currentTraceContext = currentTraceContext instanceof RequestContextCurrentTraceContext ? (RequestContextCurrentTraceContext)currentTraceContext : null;
    }

    public HttpResponse execute(ClientRequestContext ctx, HttpRequest req) throws Exception {
        RequestHeadersBuilder newHeaders = req.headers().toBuilder();
        HttpClientRequest braveReq = ClientRequestContextAdapter.asHttpClientRequest(ctx, newHeaders);
        Span span = this.handler.handleSend(braveReq);
        req = req.withHeaders(newHeaders);
        ctx.updateRequest(req);
        if (this.currentTraceContext != null && !span.isNoop() && ctx instanceof DefaultClientRequestContext) {
            DefaultClientRequestContext defaultCtx = (DefaultClientRequestContext)ctx;
            defaultCtx.hook(() -> this.currentTraceContext.newScope(span.context()));
        }
        this.maybeAddTagsToSpan(ctx, braveReq, span);
        try (Tracer.SpanInScope ignored = this.tracer.withSpanInScope(span);){
            HttpResponse httpResponse = (HttpResponse)((Client)this.unwrap()).execute(ctx, (Request)req);
            return httpResponse;
        }
    }

    private void maybeAddTagsToSpan(ClientRequestContext ctx, HttpClientRequest braveReq, Span span) {
        if (span.isNoop()) {
            return;
        }
        ctx.log().whenComplete().thenAccept(log -> {
            Long wireReceiveTimeNanos;
            span.start(log.requestStartTimeMicros());
            Long wireSendTimeNanos = log.requestFirstBytesTransferredTimeNanos();
            if (wireSendTimeNanos != null) {
                SpanTags.logWireSend(span, wireSendTimeNanos, log);
            }
            if ((wireReceiveTimeNanos = log.responseFirstBytesTransferredTimeNanos()) != null) {
                SpanTags.logWireReceive(span, wireReceiveTimeNanos, log);
            }
            SpanTags.updateRemoteEndpoint(span, (RequestContext)ctx);
            ClientConnectionTimings timings = log.connectionTimings();
            if (timings != null) {
                BraveClient.logTiming(span, "connection-acquire.start", "connection-acquire.end", timings.connectionAcquisitionStartTimeMicros(), timings.connectionAcquisitionDurationNanos());
                if (timings.dnsResolutionDurationNanos() != -1L) {
                    BraveClient.logTiming(span, "dns-resolve.start", "dns-resolve.end", timings.dnsResolutionStartTimeMicros(), timings.dnsResolutionDurationNanos());
                }
                if (timings.socketConnectDurationNanos() != -1L) {
                    BraveClient.logTiming(span, "socket-connect.start", "socket-connect.end", timings.socketConnectStartTimeMicros(), timings.socketConnectDurationNanos());
                }
                if (timings.pendingAcquisitionDurationNanos() != -1L) {
                    BraveClient.logTiming(span, "connection-reuse.start", "connection-reuse.end", timings.pendingAcquisitionStartTimeMicros(), timings.pendingAcquisitionDurationNanos());
                }
            }
            HttpClientResponse braveRes = ClientRequestContextAdapter.asHttpClientResponse(log, braveReq);
            this.handler.handleReceive(braveRes, span);
        });
    }

    private static void logTiming(Span span, String startName, String endName, long startTimeMicros, long durationNanos) {
        span.annotate(startTimeMicros, startName);
        span.annotate(startTimeMicros + TimeUnit.NANOSECONDS.toMicros(durationNanos), endName);
    }
}

