/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.brave;

import brave.Span;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.internal.common.brave.SpanContextUtil;
import com.linecorp.armeria.internal.common.brave.SpanTags;
import com.linecorp.armeria.server.ServiceRequestContext;
import javax.annotation.Nullable;

final class ServiceRequestContextAdapter {
    static brave.http.HttpServerRequest asHttpServerRequest(ServiceRequestContext ctx) {
        return new HttpServerRequest(ctx);
    }

    static brave.http.HttpServerResponse asHttpServerResponse(RequestLog log, brave.http.HttpServerRequest request) {
        return new HttpServerResponse(log, request);
    }

    @Nullable
    static String serializationFormat(RequestLog requestLog) {
        SerializationFormat serFmt = requestLog.scheme().serializationFormat();
        return serFmt == SerializationFormat.NONE ? null : serFmt.uriText();
    }

    private ServiceRequestContextAdapter() {
    }

    private static final class HttpServerRequest
    extends brave.http.HttpServerRequest {
        private final ServiceRequestContext ctx;

        HttpServerRequest(ServiceRequestContext ctx) {
            this.ctx = ctx;
        }

        public boolean parseClientIpAndPort(Span span) {
            return this.parseClientIpFromXForwardedFor(span) || SpanTags.updateRemoteEndpoint(span, (RequestContext)this.ctx);
        }

        public ServiceRequestContext unwrap() {
            return this.ctx;
        }

        public String method() {
            return this.ctx.method().name();
        }

        public String path() {
            return this.ctx.path();
        }

        public String route() {
            return this.ctx.config().route().patternString();
        }

        @Nullable
        public String url() {
            return this.ctx.request().uri().toString();
        }

        @Nullable
        public String header(String name) {
            return this.ctx.request().headers().get((CharSequence)name);
        }

        public long startTimestamp() {
            return this.ctx.log().ensureAvailable(RequestLogProperty.REQUEST_START_TIME).requestStartTimeMicros();
        }
    }

    private static final class HttpServerResponse
    extends brave.http.HttpServerResponse {
        private final RequestLog log;
        private final brave.http.HttpServerRequest request;

        HttpServerResponse(RequestLog log, brave.http.HttpServerRequest request) {
            assert (log.isComplete()) : log;
            this.log = log;
            this.request = request;
        }

        public ServiceRequestContext unwrap() {
            return (ServiceRequestContext)this.log.context();
        }

        @Nullable
        public Throwable error() {
            return this.log.responseCause();
        }

        public int statusCode() {
            return this.log.responseHeaders().status().code();
        }

        public brave.http.HttpServerRequest request() {
            return this.request;
        }

        public long finishTimestamp() {
            return SpanContextUtil.wallTimeMicros(this.log, this.log.responseEndTimeNanos());
        }
    }
}

