/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.eureka;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.ClientRequestContextCaptor;
import com.linecorp.armeria.client.Clients;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.SystemInfo;
import com.linecorp.armeria.internal.common.eureka.EurekaWebClient;
import com.linecorp.armeria.internal.common.eureka.InstanceInfo;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.RoutePathType;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerListenerAdapter;
import com.linecorp.armeria.server.ServerPort;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.eureka.EurekaUpdatingListenerBuilder;
import com.linecorp.armeria.server.eureka.InstanceInfoBuilder;
import com.linecorp.armeria.server.healthcheck.HealthCheckService;
import io.netty.channel.EventLoop;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.ScheduledFuture;
import java.net.Inet4Address;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EurekaUpdatingListener
extends ServerListenerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(EurekaUpdatingListener.class);
    private final EurekaWebClient client;
    private InstanceInfo instanceInfo;
    @Nullable
    private volatile ScheduledFuture<?> heartBeatFuture;
    @Nullable
    private volatile String appName;
    private volatile boolean closed;

    public static EurekaUpdatingListener of(String eurekaUri) {
        return EurekaUpdatingListener.of(URI.create(Objects.requireNonNull(eurekaUri, "eurekaUri")));
    }

    public static EurekaUpdatingListener of(URI eurekaUri) {
        return new EurekaUpdatingListenerBuilder(eurekaUri).build();
    }

    public static EurekaUpdatingListener of(SessionProtocol sessionProtocol, EndpointGroup endpointGroup) {
        return new EurekaUpdatingListenerBuilder(sessionProtocol, endpointGroup, null).build();
    }

    public static EurekaUpdatingListener of(SessionProtocol sessionProtocol, EndpointGroup endpointGroup, String path) {
        return new EurekaUpdatingListenerBuilder(sessionProtocol, endpointGroup, Objects.requireNonNull(path, "path")).build();
    }

    public static EurekaUpdatingListenerBuilder builder(String eurekaUri) {
        return EurekaUpdatingListener.builder(URI.create(Objects.requireNonNull(eurekaUri, "eurekaUri")));
    }

    public static EurekaUpdatingListenerBuilder builder(URI eurekaUri) {
        return new EurekaUpdatingListenerBuilder(eurekaUri);
    }

    public static EurekaUpdatingListenerBuilder builder(SessionProtocol sessionProtocol, EndpointGroup endpointGroup) {
        return new EurekaUpdatingListenerBuilder(sessionProtocol, endpointGroup, null);
    }

    public static EurekaUpdatingListenerBuilder builder(SessionProtocol sessionProtocol, EndpointGroup endpointGroup, String path) {
        return new EurekaUpdatingListenerBuilder(sessionProtocol, endpointGroup, Objects.requireNonNull(path, "path"));
    }

    EurekaUpdatingListener(EurekaWebClient client, InstanceInfo instanceInfo) {
        this.client = client;
        this.instanceInfo = instanceInfo;
    }

    public void serverStarted(Server server) throws Exception {
        this.instanceInfo = this.fillAndCreateNewInfo(this.instanceInfo, server);
        this.register(this.instanceInfo);
    }

    private void register(InstanceInfo instanceInfo) {
        try (ClientRequestContextCaptor contextCaptor = Clients.newContextCaptor();){
            HttpResponse response = this.client.register(instanceInfo);
            ClientRequestContext ctx = contextCaptor.getOrNull();
            response.aggregate().handle((res, cause) -> {
                if (this.closed) {
                    return null;
                }
                if (cause != null) {
                    logger.warn("Failed to register {} to Eureka: {}", new Object[]{instanceInfo.getHostName(), this.client.uri(), cause});
                    return null;
                }
                ResponseHeaders headers = res.headers();
                if (headers.status() != HttpStatus.NO_CONTENT) {
                    logger.warn("Failed to register {} to Eureka: {}. (status: {}, content: {})", new Object[]{instanceInfo.getHostName(), this.client.uri(), headers.status(), res.contentUtf8()});
                } else {
                    logger.info("Registered {} to Eureka: {}", (Object)instanceInfo.getHostName(), (Object)this.client.uri());
                    assert (ctx != null);
                    this.scheduleHeartBeat(ctx.eventLoop().withoutContext(), instanceInfo);
                }
                return null;
            });
        }
    }

    private void scheduleHeartBeat(EventLoop eventLoop, InstanceInfo newInfo) {
        this.heartBeatFuture = eventLoop.schedule((Runnable)new HeartBeatTask(eventLoop, newInfo), (long)newInfo.getLeaseInfo().getRenewalIntervalInSecs(), TimeUnit.SECONDS);
    }

    private InstanceInfo fillAndCreateNewInfo(InstanceInfo oldInfo, Server server) {
        String defaultHostname = server.defaultHostname();
        String hostName = oldInfo.getHostName() != null ? oldInfo.getHostName() : defaultHostname;
        this.appName = oldInfo.getAppName() != null ? oldInfo.getAppName() : hostName;
        Inet4Address defaultInet4Address = SystemInfo.defaultNonLoopbackIpV4Address();
        String defaultIpAddr = defaultInet4Address != null ? defaultInet4Address.getHostAddress() : null;
        String ipAddr = oldInfo.getIpAddr() != null ? oldInfo.getIpAddr() : defaultIpAddr;
        InstanceInfo.PortWrapper oldPortWrapper = oldInfo.getPort();
        InstanceInfo.PortWrapper portWrapper = EurekaUpdatingListener.portWrapper(server, oldPortWrapper, SessionProtocol.HTTP);
        InstanceInfo.PortWrapper oldSecurePortWrapper = oldInfo.getSecurePort();
        InstanceInfo.PortWrapper securePortWrapper = EurekaUpdatingListener.portWrapper(server, oldSecurePortWrapper, SessionProtocol.HTTPS);
        int instancePort = portWrapper.isEnabled() ? portWrapper.getPort() : securePortWrapper.getPort();
        String instanceId = oldInfo.getInstanceId() != null ? oldInfo.getInstanceId() : hostName + ':' + this.appName + ':' + instancePort;
        String vipAddress = EurekaUpdatingListener.vipAddress(oldInfo.getVipAddress(), hostName, portWrapper);
        String secureVipAddress = EurekaUpdatingListener.vipAddress(oldInfo.getSecureVipAddress(), hostName, securePortWrapper);
        Optional<ServiceConfig> healthCheckService = server.serviceConfigs().stream().filter(cfg -> cfg.service().as(HealthCheckService.class) != null).findFirst();
        String hostnameOrIpAddr = oldInfo.getHostName() != null ? oldInfo.getHostName() : (ipAddr != null ? ipAddr : hostName);
        String healthCheckUrl = EurekaUpdatingListener.healthCheckUrl(hostnameOrIpAddr, oldInfo.getHealthCheckUrl(), portWrapper, healthCheckService, SessionProtocol.HTTP);
        String secureHealthCheckUrl = EurekaUpdatingListener.healthCheckUrl(hostnameOrIpAddr, oldInfo.getSecureHealthCheckUrl(), securePortWrapper, healthCheckService, SessionProtocol.HTTPS);
        return new InstanceInfo(instanceId, this.appName, oldInfo.getAppGroupName(), hostName, ipAddr, vipAddress, secureVipAddress, portWrapper, securePortWrapper, InstanceInfo.InstanceStatus.UP, oldInfo.getHomePageUrl(), oldInfo.getStatusPageUrl(), healthCheckUrl, secureHealthCheckUrl, oldInfo.getDataCenterInfo(), oldInfo.getLeaseInfo(), oldInfo.getMetadata());
    }

    private static InstanceInfo.PortWrapper portWrapper(Server server, InstanceInfo.PortWrapper oldPortWrapper, SessionProtocol protocol) {
        if (oldPortWrapper.isEnabled()) {
            for (ServerPort serverPort : server.activePorts().values()) {
                if (!serverPort.hasProtocol(protocol) || serverPort.localAddress().getPort() != oldPortWrapper.getPort()) continue;
                return oldPortWrapper;
            }
            logger.warn("The specified port number {} does not exist. (expected one of activePorts: {})", (Object)oldPortWrapper.getPort(), (Object)server.activePorts());
            return oldPortWrapper;
        }
        ServerPort serverPort = server.activePort(protocol);
        if (serverPort == null) {
            return InstanceInfoBuilder.disabledPort;
        }
        return new InstanceInfo.PortWrapper(true, serverPort.localAddress().getPort());
    }

    @Nullable
    private static String vipAddress(@Nullable String vipAddress, String hostName, InstanceInfo.PortWrapper portWrapper) {
        if (!portWrapper.isEnabled()) {
            return null;
        }
        return vipAddress != null ? vipAddress : hostName + ':' + portWrapper.getPort();
    }

    @Nullable
    private static String healthCheckUrl(String hostnameOrIpAddr, @Nullable String oldHealthCheckUrl, InstanceInfo.PortWrapper portWrapper, Optional<ServiceConfig> healthCheckService, SessionProtocol sessionProtocol) {
        if (oldHealthCheckUrl != null) {
            return oldHealthCheckUrl;
        }
        if (!portWrapper.isEnabled() || !healthCheckService.isPresent()) {
            return null;
        }
        ServiceConfig healthCheckServiceConfig = healthCheckService.get();
        Route route = healthCheckServiceConfig.route();
        if (route.pathType() != RoutePathType.EXACT && route.pathType() != RoutePathType.PREFIX) {
            return null;
        }
        return sessionProtocol.uriText() + "://" + EurekaUpdatingListener.hostnameOrIpAddr(hostnameOrIpAddr) + ':' + portWrapper.getPort() + (String)route.paths().get(0);
    }

    private static String hostnameOrIpAddr(String hostnameOrIpAddr) {
        if (NetUtil.isValidIpV6Address((String)hostnameOrIpAddr) && hostnameOrIpAddr.charAt(0) != '[') {
            return '[' + hostnameOrIpAddr + ']';
        }
        return hostnameOrIpAddr;
    }

    public void serverStopping(Server server) throws Exception {
        String appName;
        this.closed = true;
        ScheduledFuture<?> heartBeatFuture = this.heartBeatFuture;
        if (heartBeatFuture != null) {
            heartBeatFuture.cancel(false);
        }
        if ((appName = this.appName) != null) {
            String instanceId = this.instanceInfo.getInstanceId();
            assert (instanceId != null);
            this.client.cancel(appName, instanceId).aggregate().handle((res, cause) -> {
                if (cause != null) {
                    logger.warn("Failed to deregister from Eureka: {}", (Object)this.client.uri(), cause);
                } else if (!res.status().isSuccess()) {
                    logger.warn("Failed to deregister from Eureka: {} (status: {}, content: {})", new Object[]{this.client.uri(), res.status(), res.contentUtf8()});
                }
                return null;
            });
        }
    }

    private class HeartBeatTask
    implements Runnable {
        private final EventLoop eventLoop;
        private final InstanceInfo instanceInfo;

        HeartBeatTask(EventLoop eventLoop, InstanceInfo instanceInfo) {
            this.eventLoop = eventLoop;
            this.instanceInfo = instanceInfo;
        }

        @Override
        public void run() {
            String appName = this.instanceInfo.getAppName();
            String instanceId = this.instanceInfo.getInstanceId();
            assert (appName != null);
            assert (instanceId != null);
            EurekaUpdatingListener.this.client.sendHeartBeat(appName, instanceId, this.instanceInfo, null).aggregate().handle((res, cause) -> {
                if (EurekaUpdatingListener.this.closed) {
                    return null;
                }
                if (cause != null) {
                    logger.warn("Failed to send a heart beat to Eureka: {}", (Object)EurekaUpdatingListener.this.client.uri(), cause);
                } else {
                    HttpStatus status = res.status();
                    if (status == HttpStatus.OK) {
                        logger.debug("Sent a heart beat to Eureka: {}", (Object)EurekaUpdatingListener.this.client.uri());
                    } else {
                        if (status == HttpStatus.NOT_FOUND) {
                            logger.warn("Instance {}/{} no longer registered with Eureka. Attempting re-registration.", (Object)appName, (Object)instanceId);
                            EurekaUpdatingListener.this.register(this.instanceInfo);
                            return null;
                        }
                        logger.warn("Failed to send a heart beat to Eureka: {}, (status: {}, content: {})", new Object[]{EurekaUpdatingListener.this.client.uri(), res.status(), res.contentUtf8()});
                    }
                }
                EurekaUpdatingListener.this.heartBeatFuture = this.eventLoop.schedule((Runnable)this, (long)this.instanceInfo.getLeaseInfo().getRenewalIntervalInSecs(), TimeUnit.SECONDS);
                return null;
            });
        }
    }
}

