/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.eureka;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.eureka.DataCenterInfo;
import com.linecorp.armeria.internal.common.eureka.InstanceInfo;
import com.linecorp.armeria.internal.common.eureka.LeaseInfo;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import io.netty.util.NetUtil;
import java.util.Map;
import java.util.Objects;

final class InstanceInfoBuilder {
    static final InstanceInfo.PortWrapper disabledPort = new InstanceInfo.PortWrapper(false, 0);
    private int renewalIntervalSeconds = 30;
    private int leaseDurationSeconds = 90;
    @Nullable
    private String hostname;
    @Nullable
    private String instanceId;
    @Nullable
    private String appName;
    @Nullable
    private String appGroupName;
    @Nullable
    private String ipAddr;
    private InstanceInfo.PortWrapper port = disabledPort;
    private InstanceInfo.PortWrapper securePort = disabledPort;
    @Nullable
    private String vipAddress;
    @Nullable
    private String secureVipAddress;
    @Nullable
    private String homePageUrl;
    @Nullable
    private String statusPageUrl;
    @Nullable
    private String healthCheckUrlPath;
    @Nullable
    private String healthCheckUrl;
    @Nullable
    private String secureHealthCheckUrl;
    private Map<String, String> metadata = ImmutableMap.of();
    private String dataCenterName = "MyOwn";
    private Map<String, String> dataCenterMetadata = ImmutableMap.of();

    InstanceInfoBuilder() {
    }

    InstanceInfoBuilder renewalIntervalSeconds(int renewalIntervalSeconds) {
        Preconditions.checkArgument((renewalIntervalSeconds > 0 ? 1 : 0) != 0, (String)"renewalIntervalInSecs: %s (expected: > 0)", (int)renewalIntervalSeconds);
        this.renewalIntervalSeconds = renewalIntervalSeconds;
        return this;
    }

    InstanceInfoBuilder leaseDurationSeconds(int leaseDurationSeconds) {
        Preconditions.checkArgument((leaseDurationSeconds > 0 ? 1 : 0) != 0, (String)"durationInSecs: %s (expected: > 0)", (int)leaseDurationSeconds);
        this.leaseDurationSeconds = leaseDurationSeconds;
        return this;
    }

    InstanceInfoBuilder hostname(String hostname) {
        this.hostname = Objects.requireNonNull(hostname, "hostname");
        return this;
    }

    InstanceInfoBuilder instanceId(String instanceId) {
        this.instanceId = Objects.requireNonNull(instanceId, "instanceId");
        return this;
    }

    InstanceInfoBuilder appName(String appName) {
        this.appName = Objects.requireNonNull(appName, "appName");
        return this;
    }

    InstanceInfoBuilder appGroupName(String appGroupName) {
        this.appGroupName = Objects.requireNonNull(appGroupName, "appGroupName");
        return this;
    }

    InstanceInfoBuilder ipAddr(String ipAddr) {
        Objects.requireNonNull(ipAddr, "ipAddr");
        InstanceInfoBuilder.validateIpAddr(ipAddr, "ipAddr");
        this.ipAddr = ipAddr;
        return this;
    }

    InstanceInfoBuilder port(int port) {
        Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (String)"port: %s (expected: > 0)", (int)port);
        this.port = new InstanceInfo.PortWrapper(true, port);
        return this;
    }

    InstanceInfoBuilder securePort(int securePort) {
        Preconditions.checkArgument((securePort > 0 ? 1 : 0) != 0, (String)"securePort: %s (expected: > 0)", (int)securePort);
        this.securePort = new InstanceInfo.PortWrapper(true, securePort);
        return this;
    }

    InstanceInfoBuilder vipAddress(String vipAddress) {
        this.vipAddress = Objects.requireNonNull(vipAddress, "vipAddress");
        return this;
    }

    InstanceInfoBuilder secureVipAddress(String secureVipAddress) {
        this.secureVipAddress = Objects.requireNonNull(secureVipAddress, "secureVipAddress");
        return this;
    }

    InstanceInfoBuilder homePageUrl(String homePageUrl) {
        this.homePageUrl = Objects.requireNonNull(homePageUrl, "homePageUrl");
        return this;
    }

    InstanceInfoBuilder statusPageUrl(String statusPageUrl) {
        this.statusPageUrl = Objects.requireNonNull(statusPageUrl, "statusPageUrl");
        return this;
    }

    InstanceInfoBuilder healthCheckUrlPath(String healthCheckUrlPath) {
        this.healthCheckUrlPath = Objects.requireNonNull(healthCheckUrlPath, "healthCheckUrlPath");
        return this;
    }

    InstanceInfoBuilder healthCheckUrl(String healthCheckUrl) {
        this.healthCheckUrl = Objects.requireNonNull(healthCheckUrl, "healthCheckUrl");
        return this;
    }

    InstanceInfoBuilder secureHealthCheckUrl(String secureHealthCheckUrl) {
        this.secureHealthCheckUrl = Objects.requireNonNull(secureHealthCheckUrl, "secureHealthCheckUrl");
        return this;
    }

    InstanceInfoBuilder metadata(Map<String, String> metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata");
        return this;
    }

    InstanceInfoBuilder dataCenterName(String dataCenterName) {
        this.dataCenterName = Objects.requireNonNull(dataCenterName, "dataCenterName");
        return this;
    }

    InstanceInfoBuilder dataCenterMetadata(Map<String, String> dataCenterMetadata) {
        this.dataCenterMetadata = Objects.requireNonNull(dataCenterMetadata, "dataCenterMetadata");
        return this;
    }

    InstanceInfo build() {
        LeaseInfo leaseInfo = new LeaseInfo(this.renewalIntervalSeconds, this.leaseDurationSeconds);
        return new InstanceInfo(this.instanceId, this.appName, this.appGroupName, this.hostname, this.ipAddr, this.vipAddress, this.secureVipAddress, this.port, this.securePort, InstanceInfo.InstanceStatus.UP, this.homePageUrl, this.statusPageUrl, this.healthCheckUrlPath, this.healthCheckUrl, this.secureHealthCheckUrl, new DataCenterInfo(this.dataCenterName, this.dataCenterMetadata), leaseInfo, this.metadata);
    }

    private static void validateIpAddr(String ipAddr, String name) {
        if (!NetUtil.isValidIpV4Address((String)ipAddr) && !NetUtil.isValidIpV6Address((String)ipAddr)) {
            throw new IllegalArgumentException("Invalid " + name + ": " + ipAddr);
        }
    }
}

