/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.eureka;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.linecorp.armeria.internal.common.eureka.DataCenterInfo;
import java.io.IOException;
import java.util.Map;

final class DataCenterInfoSerializer
extends StdSerializer<DataCenterInfo> {
    private static final long serialVersionUID = -5766818057428683420L;

    DataCenterInfoSerializer() {
        super(DataCenterInfo.class);
    }

    public void serialize(DataCenterInfo value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        boolean isAmazon = "Amazon".equalsIgnoreCase(value.getName());
        if (isAmazon) {
            gen.writeStringField("@class", "com.netflix.appinfo.AmazonInfo");
        } else {
            gen.writeStringField("@class", "com.netflix.appinfo.InstanceInfo$DefaultDataCenterInfo");
        }
        gen.writeStringField("name", value.getName());
        if (isAmazon) {
            Map<String, String> metadata = value.getMetadata();
            gen.writeFieldName("metadata");
            gen.writeStartObject();
            if (!metadata.isEmpty()) {
                for (Map.Entry<String, String> entry : metadata.entrySet()) {
                    gen.writeStringField(entry.getKey(), entry.getValue());
                }
            }
            gen.writeEndObject();
        }
        gen.writeEndObject();
    }
}

