/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.eureka;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.errorprone.annotations.CheckReturnValue;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.QueryParams;
import com.linecorp.armeria.common.QueryParamsBuilder;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.eureka.InstanceInfo;
import com.linecorp.armeria.internal.shaded.guava.collect.Iterables;
import java.net.URI;
import java.util.Objects;

public final class EurekaWebClient {
    private static final String APPS = "/apps/";
    private static final String VIPS = "/vips/";
    private static final String SVIPS = "/svips/";
    private static final String INSTANCES = "/instances/";
    private final WebClient webClient;
    private final ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.WRAP_ROOT_VALUE).setSerializationInclusion(JsonInclude.Include.NON_NULL);

    public EurekaWebClient(WebClient webClient) {
        this.webClient = Objects.requireNonNull(webClient, "webClient");
    }

    public URI uri() {
        return this.webClient.uri();
    }

    @CheckReturnValue
    public HttpResponse register(InstanceInfo info) {
        Objects.requireNonNull(info, "info");
        String path = APPS + info.getAppName();
        RequestHeaders headers = RequestHeaders.builder((HttpMethod)HttpMethod.POST, (String)path).contentType(MediaType.JSON).build();
        try {
            return this.webClient.execute(headers, this.mapper.writeValueAsBytes((Object)info));
        }
        catch (JsonProcessingException e) {
            return HttpResponse.ofFailure((Throwable)e);
        }
    }

    @CheckReturnValue
    public HttpResponse sendHeartBeat(String appName, String instanceId, InstanceInfo instanceInfo, @Nullable InstanceInfo.InstanceStatus overriddenStatus) {
        Objects.requireNonNull(appName, "appName");
        Objects.requireNonNull(instanceId, "instanceId");
        Objects.requireNonNull(instanceInfo, "instanceInfo");
        String path = APPS + appName + '/' + instanceId;
        QueryParamsBuilder queryBuilder = QueryParams.builder().add("status", instanceInfo.getStatus().toString()).addLong("lastDirtyTimestamp", instanceInfo.getLastDirtyTimestamp());
        if (overriddenStatus != null) {
            queryBuilder.add("overriddenstatus", overriddenStatus.toString());
        }
        RequestHeaders headers = RequestHeaders.builder((HttpMethod)HttpMethod.PUT, (String)(path + '?' + queryBuilder.toQueryString())).accept(new MediaType[]{MediaType.JSON}).build();
        return this.webClient.execute(headers);
    }

    @CheckReturnValue
    public HttpResponse cancel(String appName, String instanceId) {
        Objects.requireNonNull(appName, "appName");
        Objects.requireNonNull(instanceId, "instanceId");
        String path = APPS + appName + '/' + instanceId;
        return this.webClient.delete(path);
    }

    @CheckReturnValue
    public HttpResponse getApplications(Iterable<String> regions) {
        return this.getApplications(APPS, Objects.requireNonNull(regions, "regions"));
    }

    private HttpResponse getApplications(String path, Iterable<String> regions) {
        if (!Iterables.isEmpty(regions)) {
            QueryParams queryParams = QueryParams.of((String)"regions", (String)String.join((CharSequence)",", regions));
            path = path + '?' + queryParams.toQueryString();
        }
        return this.sendGetRequest(path);
    }

    private HttpResponse sendGetRequest(String path) {
        RequestHeaders headers = RequestHeaders.builder((HttpMethod)HttpMethod.GET, (String)path).accept(new MediaType[]{MediaType.JSON}).build();
        return this.webClient.execute(headers);
    }

    @CheckReturnValue
    public HttpResponse getDelta(Iterable<String> regions) {
        return this.getApplications("/apps/delta", Objects.requireNonNull(regions, "regions"));
    }

    @CheckReturnValue
    public HttpResponse getApplication(String appName) {
        return this.sendGetRequest(APPS + Objects.requireNonNull(appName, "appName"));
    }

    @CheckReturnValue
    public HttpResponse getVip(String vipAddress, Iterable<String> regions) {
        return this.getApplications(VIPS + Objects.requireNonNull(vipAddress, "vipAddress"), Objects.requireNonNull(regions, "regions"));
    }

    @CheckReturnValue
    public HttpResponse getSecureVip(String secureVipAddress, Iterable<String> regions) {
        return this.getApplications(SVIPS + Objects.requireNonNull(secureVipAddress, "secureVipAddress"), Objects.requireNonNull(regions, "regions"));
    }

    @CheckReturnValue
    public HttpResponse getInstance(String appName, String instanceId) {
        return this.sendGetRequest(APPS + Objects.requireNonNull(appName, "appName") + '/' + Objects.requireNonNull(instanceId, "instanceId"));
    }

    @CheckReturnValue
    public HttpResponse getInstance(String instanceId) {
        return this.sendGetRequest(INSTANCES + Objects.requireNonNull(instanceId, "instanceId"));
    }
}

