/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.eureka;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.eureka.DataCenterInfo;
import com.linecorp.armeria.internal.common.eureka.LeaseInfo;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Objects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonRootName(value="instance")
public final class InstanceInfo {
    private static final Logger logger = LoggerFactory.getLogger(InstanceInfo.class);
    private final String instanceId;
    @Nullable
    private final String hostName;
    @Nullable
    private final String appName;
    @Nullable
    private final String appGroupName;
    @Nullable
    private final String ipAddr;
    @Nullable
    private final String vipAddress;
    @Nullable
    private final String secureVipAddress;
    private final PortWrapper port;
    private final PortWrapper securePort;
    private final InstanceStatus status;
    @Nullable
    private final String homePageUrlPath;
    @Nullable
    private final String homePageUrl;
    @Nullable
    private final String statusPageUrlPath;
    @Nullable
    private final String statusPageUrl;
    @Nullable
    private final String healthCheckUrlPath;
    @Nullable
    private final String healthCheckUrl;
    @Nullable
    private final String secureHealthCheckUrl;
    private final DataCenterInfo dataCenterInfo;
    private final LeaseInfo leaseInfo;
    private final Map<String, String> metadata;
    private final long lastUpdatedTimestamp;
    private final long lastDirtyTimestamp;

    public InstanceInfo(@Nullable @JsonProperty(value="instanceId") String instanceId, @Nullable @JsonProperty(value="app") String appName, @Nullable @JsonProperty(value="appGroupName") String appGroupName, @Nullable @JsonProperty(value="hostName") String hostName, @Nullable @JsonProperty(value="ipAddr") String ipAddr, @Nullable @JsonProperty(value="vipAddress") String vipAddress, @Nullable @JsonProperty(value="secureVipAddress") String secureVipAddress, @JsonProperty(value="port") PortWrapper port, @JsonProperty(value="securePort") PortWrapper securePort, @JsonProperty(value="status") InstanceStatus status, @Nullable @JsonProperty(value="homePageUrl") String homePageUrl, @Nullable @JsonProperty(value="statusPageUrl") String statusPageUrl, @Nullable @JsonProperty(value="healthCheckUrl") String healthCheckUrl, @Nullable @JsonProperty(value="secureHealthCheckUrl") String secureHealthCheckUrl, @JsonProperty(value="dataCenterInfo") DataCenterInfo dataCenterInfo, @JsonProperty(value="leaseInfo") LeaseInfo leaseInfo, @Nullable @JsonProperty(value="metadata") Map<String, String> metadata) {
        this(instanceId, appName, appGroupName, hostName, ipAddr, vipAddress, secureVipAddress, port, securePort, status, null, homePageUrl, null, statusPageUrl, null, healthCheckUrl, secureHealthCheckUrl, dataCenterInfo, leaseInfo, metadata);
    }

    public InstanceInfo(@Nullable String instanceId, @Nullable String appName, @Nullable String appGroupName, @Nullable String hostName, @Nullable String ipAddr, @Nullable String vipAddress, @Nullable String secureVipAddress, PortWrapper port, PortWrapper securePort, InstanceStatus status, @Nullable String homePageUrlPath, @Nullable String homePageUrl, @Nullable String statusPageUrlPath, @Nullable String statusPageUrl, @Nullable String healthCheckUrlPath, @Nullable String healthCheckUrl, @Nullable String secureHealthCheckUrl, DataCenterInfo dataCenterInfo, LeaseInfo leaseInfo, @Nullable Map<String, String> metadata) {
        this.instanceId = instanceId;
        this.hostName = hostName;
        this.appName = appName;
        this.appGroupName = appGroupName;
        this.ipAddr = ipAddr;
        this.vipAddress = vipAddress;
        this.secureVipAddress = secureVipAddress;
        this.port = java.util.Objects.requireNonNull(port, "port");
        this.securePort = java.util.Objects.requireNonNull(securePort, "securePort");
        this.status = java.util.Objects.requireNonNull(status, "status");
        this.homePageUrlPath = homePageUrlPath;
        this.homePageUrl = homePageUrl;
        this.statusPageUrlPath = statusPageUrlPath;
        this.statusPageUrl = statusPageUrl;
        this.healthCheckUrlPath = healthCheckUrlPath;
        this.healthCheckUrl = healthCheckUrl;
        this.secureHealthCheckUrl = secureHealthCheckUrl;
        this.dataCenterInfo = dataCenterInfo;
        this.leaseInfo = java.util.Objects.requireNonNull(leaseInfo, "leaseInfo");
        this.metadata = metadata != null ? metadata : ImmutableMap.of();
        this.lastDirtyTimestamp = this.lastUpdatedTimestamp = System.currentTimeMillis();
    }

    @Nullable
    public String getInstanceId() {
        return this.instanceId;
    }

    @Nullable
    @JsonProperty(value="app")
    public String getAppName() {
        return this.appName;
    }

    @Nullable
    public String getAppGroupName() {
        return this.appGroupName;
    }

    @Nullable
    public String getHostName() {
        return this.hostName;
    }

    @Nullable
    public String getIpAddr() {
        return this.ipAddr;
    }

    @Nullable
    public String getVipAddress() {
        return this.vipAddress;
    }

    @Nullable
    public String getSecureVipAddress() {
        return this.secureVipAddress;
    }

    public PortWrapper getPort() {
        return this.port;
    }

    public PortWrapper getSecurePort() {
        return this.securePort;
    }

    public InstanceStatus getStatus() {
        return this.status;
    }

    @Nullable
    @JsonIgnore
    public String getHomePageUrlPath() {
        return this.homePageUrlPath;
    }

    @Nullable
    public String getHomePageUrl() {
        return this.homePageUrl;
    }

    @Nullable
    @JsonIgnore
    public String getStatusPageUrlPath() {
        return this.statusPageUrlPath;
    }

    @Nullable
    public String getStatusPageUrl() {
        return this.statusPageUrl;
    }

    @Nullable
    @JsonIgnore
    public String getHealthCheckUrlPath() {
        return this.healthCheckUrlPath;
    }

    @Nullable
    public String getHealthCheckUrl() {
        return this.healthCheckUrl;
    }

    @Nullable
    public String getSecureHealthCheckUrl() {
        return this.secureHealthCheckUrl;
    }

    public DataCenterInfo getDataCenterInfo() {
        return this.dataCenterInfo;
    }

    public LeaseInfo getLeaseInfo() {
        return this.leaseInfo;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public long getLastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public long getLastDirtyTimestamp() {
        return this.lastDirtyTimestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstanceInfo)) {
            return false;
        }
        InstanceInfo that = (InstanceInfo)o;
        return Objects.equal((Object)this.instanceId, (Object)that.instanceId) && Objects.equal((Object)this.hostName, (Object)that.hostName) && Objects.equal((Object)this.appName, (Object)that.appName) && Objects.equal((Object)this.appGroupName, (Object)that.appGroupName) && Objects.equal((Object)this.ipAddr, (Object)that.ipAddr) && Objects.equal((Object)this.vipAddress, (Object)that.vipAddress) && Objects.equal((Object)this.secureVipAddress, (Object)that.secureVipAddress) && Objects.equal((Object)this.port, (Object)that.port) && Objects.equal((Object)this.securePort, (Object)that.securePort) && this.status == that.status && Objects.equal((Object)this.homePageUrlPath, (Object)that.homePageUrlPath) && Objects.equal((Object)this.homePageUrl, (Object)that.homePageUrl) && Objects.equal((Object)this.statusPageUrlPath, (Object)that.statusPageUrlPath) && Objects.equal((Object)this.statusPageUrl, (Object)that.statusPageUrl) && Objects.equal((Object)this.healthCheckUrlPath, (Object)that.healthCheckUrlPath) && Objects.equal((Object)this.healthCheckUrl, (Object)that.healthCheckUrl) && Objects.equal((Object)this.secureHealthCheckUrl, (Object)that.secureHealthCheckUrl) && Objects.equal((Object)this.dataCenterInfo, (Object)that.dataCenterInfo) && Objects.equal((Object)this.leaseInfo, (Object)that.leaseInfo) && Objects.equal(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.instanceId, this.hostName, this.appName, this.appGroupName, this.ipAddr, this.vipAddress, this.secureVipAddress, this.port, this.securePort, this.status, this.homePageUrlPath, this.homePageUrl, this.statusPageUrlPath, this.statusPageUrl, this.healthCheckUrlPath, this.healthCheckUrl, this.secureHealthCheckUrl, this.dataCenterInfo, this.leaseInfo, this.metadata});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("instanceId", (Object)this.instanceId).add("hostName", (Object)this.hostName).add("appName", (Object)this.appName).add("appGroupName", (Object)this.appGroupName).add("ipAddr", (Object)this.ipAddr).add("vipAddress", (Object)this.vipAddress).add("secureVipAddress", (Object)this.secureVipAddress).add("port", (Object)this.port).add("securePort", (Object)this.securePort).add("status", (Object)this.status).add("homePageUrlPath", (Object)this.homePageUrlPath).add("homePageUrl", (Object)this.homePageUrl).add("statusPageUrlPath", (Object)this.statusPageUrlPath).add("statusPageUrl", (Object)this.statusPageUrl).add("healthCheckUrlPath", (Object)this.healthCheckUrlPath).add("healthCheckUrl", (Object)this.healthCheckUrl).add("secureHealthCheckUrl", (Object)this.secureHealthCheckUrl).add("dataCenterInfo", (Object)this.dataCenterInfo).add("leaseInfo", (Object)this.leaseInfo).add("metadata", this.metadata).add("lastUpdatedTimestamp", this.lastUpdatedTimestamp).add("lastDirtyTimestamp", this.lastDirtyTimestamp).toString();
    }

    public static class PortWrapper {
        private final boolean enabled;
        private final int port;

        public PortWrapper(@JsonProperty(value="@enabled") boolean enabled, @JsonProperty(value="$") int port) {
            this.enabled = enabled;
            this.port = port;
        }

        @JsonProperty(value="@enabled")
        @JsonSerialize(using=ToStringSerializer.class)
        public boolean isEnabled() {
            return this.enabled;
        }

        @JsonProperty(value="$")
        public int getPort() {
            return this.port;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PortWrapper)) {
                return false;
            }
            PortWrapper that = (PortWrapper)obj;
            return this.enabled == that.enabled && this.port == that.port;
        }

        public int hashCode() {
            return this.port * 31 + Boolean.hashCode(this.enabled);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("enabled", this.enabled).add("port", this.port).toString();
        }
    }

    public static enum InstanceStatus {
        UP,
        DOWN,
        STARTING,
        OUT_OF_SERVICE,
        UNKNOWN;


        public static InstanceStatus toEnum(String str) {
            java.util.Objects.requireNonNull(str, "str");
            try {
                return InstanceStatus.valueOf(str);
            }
            catch (IllegalArgumentException e) {
                logger.warn("unknown enum value: {} (expected: {}), {} is set by default. ", new Object[]{str, InstanceStatus.values(), UNKNOWN});
                return UNKNOWN;
            }
        }
    }
}

