/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.eureka;

import com.linecorp.armeria.client.AbstractWebClientBuilder;
import com.linecorp.armeria.client.ClientBuilderParams;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientOption;
import com.linecorp.armeria.client.ClientOptionValue;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.DecoratingHttpClientFunction;
import com.linecorp.armeria.client.DecoratingRpcClientFunction;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.RpcClient;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.retry.RetryingClient;
import com.linecorp.armeria.common.RequestId;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.SuccessFunction;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.auth.AuthToken;
import com.linecorp.armeria.common.auth.BasicToken;
import com.linecorp.armeria.common.auth.OAuth1aToken;
import com.linecorp.armeria.common.auth.OAuth2Token;
import com.linecorp.armeria.internal.common.eureka.EurekaClientUtil;
import com.linecorp.armeria.internal.common.eureka.EurekaWebClient;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.primitives.Ints;
import com.linecorp.armeria.server.eureka.EurekaUpdatingListener;
import com.linecorp.armeria.server.eureka.InstanceInfoBuilder;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class EurekaUpdatingListenerBuilder
extends AbstractWebClientBuilder {
    static final int DEFAULT_LEASE_RENEWAL_INTERVAL_SECONDS = 30;
    static final int DEFAULT_LEASE_DURATION_SECONDS = 90;
    static final String DEFAULT_DATA_CENTER_NAME = "MyOwn";
    private final InstanceInfoBuilder instanceInfoBuilder = new InstanceInfoBuilder();

    EurekaUpdatingListenerBuilder(URI eurekaUri) {
        super(Objects.requireNonNull(eurekaUri, "eurekaUri"));
    }

    EurekaUpdatingListenerBuilder(SessionProtocol sessionProtocol, EndpointGroup endpointGroup, @Nullable String path) {
        super(sessionProtocol, endpointGroup, path);
    }

    public EurekaUpdatingListenerBuilder renewalInterval(Duration renewalInterval) {
        Objects.requireNonNull(renewalInterval, "renewalInterval");
        Preconditions.checkArgument((!renewalInterval.isZero() && !renewalInterval.isNegative() ? 1 : 0) != 0, (String)"renewalInterval: %s (expected: > 0)", (Object)renewalInterval);
        int renewalIntervalSeconds = Ints.saturatedCast((long)(renewalInterval.getSeconds() + (long)(renewalInterval.getNano() != 0 ? 1 : 0)));
        this.instanceInfoBuilder.renewalIntervalSeconds(renewalIntervalSeconds);
        return this;
    }

    @Deprecated
    public EurekaUpdatingListenerBuilder renewalIntervalSeconds(int renewalIntervalSeconds) {
        this.instanceInfoBuilder.renewalIntervalSeconds(renewalIntervalSeconds);
        return this;
    }

    public EurekaUpdatingListenerBuilder renewalIntervalMillis(long renewalIntervalMillis) {
        Preconditions.checkArgument((renewalIntervalMillis > 0L ? 1 : 0) != 0, (String)"renewalIntervalMillis: %s (expected: > 0)", (long)renewalIntervalMillis);
        int renewalIntervalSeconds = Ints.saturatedCast((long)(TimeUnit.MILLISECONDS.toSeconds(renewalIntervalMillis) + (long)(renewalIntervalMillis % 1000L != 0L ? 1 : 0)));
        this.instanceInfoBuilder.renewalIntervalSeconds(renewalIntervalSeconds);
        return this;
    }

    public EurekaUpdatingListenerBuilder leaseDuration(Duration leaseDuration) {
        Objects.requireNonNull(leaseDuration, "leaseDuration");
        Preconditions.checkArgument((!leaseDuration.isZero() && !leaseDuration.isNegative() ? 1 : 0) != 0, (String)"renewalInterval: %s (expected: > 0)", (Object)leaseDuration);
        int leaseDurationSeconds = Ints.saturatedCast((long)(leaseDuration.getSeconds() + (long)(leaseDuration.getNano() != 0 ? 1 : 0)));
        this.instanceInfoBuilder.leaseDurationSeconds(leaseDurationSeconds);
        return this;
    }

    @Deprecated
    public EurekaUpdatingListenerBuilder leaseDurationSeconds(int leaseDurationSeconds) {
        this.instanceInfoBuilder.leaseDurationSeconds(leaseDurationSeconds);
        return this;
    }

    public EurekaUpdatingListenerBuilder leaseDurationMillis(long leaseDurationMillis) {
        Preconditions.checkArgument((leaseDurationMillis > 0L ? 1 : 0) != 0, (String)"leaseDurationMillis: %s (expected: > 0)", (long)leaseDurationMillis);
        int leaseDurationSeconds = Ints.saturatedCast((long)(TimeUnit.MILLISECONDS.toSeconds(leaseDurationMillis) + (long)(leaseDurationMillis % 1000L != 0L ? 1 : 0)));
        this.instanceInfoBuilder.leaseDurationSeconds(leaseDurationSeconds);
        return this;
    }

    public EurekaUpdatingListenerBuilder hostname(String hostname) {
        this.instanceInfoBuilder.hostname(hostname);
        return this;
    }

    public EurekaUpdatingListenerBuilder instanceId(String instanceId) {
        this.instanceInfoBuilder.instanceId(instanceId);
        return this;
    }

    public EurekaUpdatingListenerBuilder appName(String appName) {
        this.instanceInfoBuilder.appName(appName);
        return this;
    }

    public EurekaUpdatingListenerBuilder appGroupName(String appGroupName) {
        this.instanceInfoBuilder.appGroupName(appGroupName);
        return this;
    }

    public EurekaUpdatingListenerBuilder ipAddr(String ipAddr) {
        this.instanceInfoBuilder.ipAddr(ipAddr);
        return this;
    }

    public EurekaUpdatingListenerBuilder port(int port) {
        this.instanceInfoBuilder.port(port);
        return this;
    }

    public EurekaUpdatingListenerBuilder securePort(int securePort) {
        this.instanceInfoBuilder.securePort(securePort);
        return this;
    }

    public EurekaUpdatingListenerBuilder vipAddress(String vipAddress) {
        this.instanceInfoBuilder.vipAddress(vipAddress);
        return this;
    }

    public EurekaUpdatingListenerBuilder secureVipAddress(String secureVipAddress) {
        this.instanceInfoBuilder.secureVipAddress(secureVipAddress);
        return this;
    }

    public EurekaUpdatingListenerBuilder homePageUrlPath(String homePageUrlPath) {
        this.instanceInfoBuilder.homePageUrlPath(homePageUrlPath);
        return this;
    }

    public EurekaUpdatingListenerBuilder homePageUrl(String homePageUrl) {
        this.instanceInfoBuilder.homePageUrl(homePageUrl);
        return this;
    }

    public EurekaUpdatingListenerBuilder statusPageUrlPath(String statusPageUrlPath) {
        this.instanceInfoBuilder.statusPageUrlPath(statusPageUrlPath);
        return this;
    }

    public EurekaUpdatingListenerBuilder statusPageUrl(String statusPageUrl) {
        this.instanceInfoBuilder.statusPageUrl(statusPageUrl);
        return this;
    }

    public EurekaUpdatingListenerBuilder healthCheckUrlPath(String healthCheckUrlPath) {
        this.instanceInfoBuilder.healthCheckUrlPath(healthCheckUrlPath);
        return this;
    }

    public EurekaUpdatingListenerBuilder healthCheckUrl(String healthCheckUrl) {
        this.instanceInfoBuilder.healthCheckUrl(healthCheckUrl);
        return this;
    }

    public EurekaUpdatingListenerBuilder secureHealthCheckUrl(String secureHealthCheckUrl) {
        this.instanceInfoBuilder.secureHealthCheckUrl(secureHealthCheckUrl);
        return this;
    }

    public EurekaUpdatingListenerBuilder metadata(Map<String, String> metadata) {
        this.instanceInfoBuilder.metadata(metadata);
        return this;
    }

    public EurekaUpdatingListenerBuilder dataCenterName(String dataCenterName) {
        this.instanceInfoBuilder.dataCenterName(dataCenterName);
        return this;
    }

    public EurekaUpdatingListenerBuilder dataCenterMetadata(Map<String, String> dataCenterMetadata) {
        this.instanceInfoBuilder.dataCenterMetadata(dataCenterMetadata);
        return this;
    }

    public EurekaUpdatingListener build() {
        WebClient client;
        WebClient webClient = this.buildWebClient();
        if (webClient.as(RetryingClient.class) != null) {
            client = webClient;
        } else {
            ClientOptions options = this.buildOptions(EurekaClientUtil.retryingClientOptions());
            ClientBuilderParams params = this.clientBuilderParams(options);
            ClientFactory factory = options.factory();
            client = (WebClient)factory.newClient(params);
        }
        return new EurekaUpdatingListener(new EurekaWebClient(client), this.instanceInfoBuilder.build());
    }

    public EurekaUpdatingListenerBuilder options(ClientOptions options) {
        return (EurekaUpdatingListenerBuilder)super.options(options);
    }

    public EurekaUpdatingListenerBuilder options(ClientOptionValue<?> ... options) {
        return (EurekaUpdatingListenerBuilder)super.options(options);
    }

    public EurekaUpdatingListenerBuilder options(Iterable<ClientOptionValue<?>> options) {
        return (EurekaUpdatingListenerBuilder)super.options(options);
    }

    public <T> EurekaUpdatingListenerBuilder option(ClientOption<T> option, T value) {
        return (EurekaUpdatingListenerBuilder)super.option(option, value);
    }

    public <T> EurekaUpdatingListenerBuilder option(ClientOptionValue<T> optionValue) {
        return (EurekaUpdatingListenerBuilder)super.option(optionValue);
    }

    public EurekaUpdatingListenerBuilder factory(ClientFactory factory) {
        return (EurekaUpdatingListenerBuilder)super.factory(factory);
    }

    public EurekaUpdatingListenerBuilder writeTimeout(Duration writeTimeout) {
        return (EurekaUpdatingListenerBuilder)super.writeTimeout(writeTimeout);
    }

    public EurekaUpdatingListenerBuilder writeTimeoutMillis(long writeTimeoutMillis) {
        return (EurekaUpdatingListenerBuilder)super.writeTimeoutMillis(writeTimeoutMillis);
    }

    public EurekaUpdatingListenerBuilder responseTimeout(Duration responseTimeout) {
        return (EurekaUpdatingListenerBuilder)super.responseTimeout(responseTimeout);
    }

    public EurekaUpdatingListenerBuilder responseTimeoutMillis(long responseTimeoutMillis) {
        return (EurekaUpdatingListenerBuilder)super.responseTimeoutMillis(responseTimeoutMillis);
    }

    public EurekaUpdatingListenerBuilder maxResponseLength(long maxResponseLength) {
        return (EurekaUpdatingListenerBuilder)super.maxResponseLength(maxResponseLength);
    }

    public EurekaUpdatingListenerBuilder requestAutoAbortDelay(Duration delay) {
        return (EurekaUpdatingListenerBuilder)super.requestAutoAbortDelay(delay);
    }

    public EurekaUpdatingListenerBuilder requestAutoAbortDelayMillis(long delayMillis) {
        return (EurekaUpdatingListenerBuilder)super.requestAutoAbortDelayMillis(delayMillis);
    }

    public EurekaUpdatingListenerBuilder requestIdGenerator(Supplier<RequestId> requestIdGenerator) {
        return (EurekaUpdatingListenerBuilder)super.requestIdGenerator(requestIdGenerator);
    }

    public EurekaUpdatingListenerBuilder successFunction(SuccessFunction successFunction) {
        return (EurekaUpdatingListenerBuilder)super.successFunction(successFunction);
    }

    public EurekaUpdatingListenerBuilder endpointRemapper(Function<? super Endpoint, ? extends EndpointGroup> endpointRemapper) {
        return (EurekaUpdatingListenerBuilder)super.endpointRemapper(endpointRemapper);
    }

    public EurekaUpdatingListenerBuilder decorator(Function<? super HttpClient, ? extends HttpClient> decorator) {
        return (EurekaUpdatingListenerBuilder)super.decorator(decorator);
    }

    public EurekaUpdatingListenerBuilder decorator(DecoratingHttpClientFunction decorator) {
        return (EurekaUpdatingListenerBuilder)super.decorator(decorator);
    }

    public EurekaUpdatingListenerBuilder rpcDecorator(Function<? super RpcClient, ? extends RpcClient> decorator) {
        return (EurekaUpdatingListenerBuilder)super.rpcDecorator(decorator);
    }

    public EurekaUpdatingListenerBuilder rpcDecorator(DecoratingRpcClientFunction decorator) {
        return (EurekaUpdatingListenerBuilder)super.rpcDecorator(decorator);
    }

    public EurekaUpdatingListenerBuilder clearDecorators() {
        return (EurekaUpdatingListenerBuilder)super.clearDecorators();
    }

    public EurekaUpdatingListenerBuilder addHeader(CharSequence name, Object value) {
        return (EurekaUpdatingListenerBuilder)super.addHeader(name, value);
    }

    public EurekaUpdatingListenerBuilder addHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> headers) {
        return (EurekaUpdatingListenerBuilder)super.addHeaders(headers);
    }

    public EurekaUpdatingListenerBuilder setHeader(CharSequence name, Object value) {
        return (EurekaUpdatingListenerBuilder)super.setHeader(name, value);
    }

    public EurekaUpdatingListenerBuilder setHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> headers) {
        return (EurekaUpdatingListenerBuilder)super.setHeaders(headers);
    }

    public EurekaUpdatingListenerBuilder auth(BasicToken token) {
        return (EurekaUpdatingListenerBuilder)super.auth(token);
    }

    public EurekaUpdatingListenerBuilder auth(OAuth1aToken token) {
        return (EurekaUpdatingListenerBuilder)super.auth(token);
    }

    public EurekaUpdatingListenerBuilder auth(OAuth2Token token) {
        return (EurekaUpdatingListenerBuilder)super.auth(token);
    }

    public EurekaUpdatingListenerBuilder auth(AuthToken token) {
        return (EurekaUpdatingListenerBuilder)super.auth(token);
    }

    public EurekaUpdatingListenerBuilder contextCustomizer(Consumer<? super ClientRequestContext> contextCustomizer) {
        return (EurekaUpdatingListenerBuilder)super.contextCustomizer(contextCustomizer);
    }
}

