/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.eureka;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.ClientRequestContextCaptor;
import com.linecorp.armeria.client.Clients;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.client.endpoint.DynamicEndpointGroup;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.endpoint.EndpointSelectionStrategy;
import com.linecorp.armeria.client.eureka.EurekaEndpointGroupBuilder;
import com.linecorp.armeria.common.AggregationOptions;
import com.linecorp.armeria.common.CommonPools;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.QueryParams;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.RequestHeadersBuilder;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.eureka.Application;
import com.linecorp.armeria.internal.common.eureka.Applications;
import com.linecorp.armeria.internal.common.eureka.InstanceInfo;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ScheduledFuture;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EurekaEndpointGroup
extends DynamicEndpointGroup {
    private static final Logger logger = LoggerFactory.getLogger(EurekaEndpointGroup.class);
    private static final ObjectMapper mapper = new ObjectMapper().enable(DeserializationFeature.UNWRAP_ROOT_VALUE).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    private static final Predicate<InstanceInfo> allInstances = instanceInfo -> true;
    private static final String APPS = "/apps";
    private static final String VIPS = "/vips/";
    private static final String SVIPS = "/svips/";
    private static final String INSTANCES = "/instances/";
    private final long registryFetchIntervalMillis;
    private final RequestHeaders requestHeaders;
    private final Function<byte[], List<Endpoint>> responseConverter;
    private final WebClient webClient;
    @Nullable
    private volatile ScheduledFuture<?> scheduledFuture;
    private volatile boolean closed;

    public static EurekaEndpointGroup of(String eurekaUri) {
        return EurekaEndpointGroup.of(URI.create(Objects.requireNonNull(eurekaUri, "eurekaUri")));
    }

    public static EurekaEndpointGroup of(URI eurekaUri) {
        return new EurekaEndpointGroupBuilder(eurekaUri).build();
    }

    public static EurekaEndpointGroup of(SessionProtocol sessionProtocol, EndpointGroup endpointGroup) {
        return new EurekaEndpointGroupBuilder(sessionProtocol, endpointGroup, null).build();
    }

    public static EurekaEndpointGroup of(SessionProtocol sessionProtocol, EndpointGroup endpointGroup, String path) {
        return new EurekaEndpointGroupBuilder(sessionProtocol, endpointGroup, Objects.requireNonNull(path, "path")).build();
    }

    public static EurekaEndpointGroupBuilder builder(String eurekaUri) {
        return EurekaEndpointGroup.builder(URI.create(Objects.requireNonNull(eurekaUri, "eurekaUri")));
    }

    public static EurekaEndpointGroupBuilder builder(URI eurekaUri) {
        return new EurekaEndpointGroupBuilder(eurekaUri);
    }

    public static EurekaEndpointGroupBuilder builder(SessionProtocol sessionProtocol, EndpointGroup endpointGroup) {
        return new EurekaEndpointGroupBuilder(sessionProtocol, endpointGroup, null);
    }

    public static EurekaEndpointGroupBuilder builder(SessionProtocol sessionProtocol, EndpointGroup endpointGroup, String path) {
        return new EurekaEndpointGroupBuilder(sessionProtocol, endpointGroup, Objects.requireNonNull(path, "path"));
    }

    EurekaEndpointGroup(EndpointSelectionStrategy selectionStrategy, boolean allowEmptyEndpoints, long selectionTimeoutMillis, WebClient webClient, long registryFetchIntervalMillis, @Nullable String appName, @Nullable String instanceId, @Nullable String vipAddress, @Nullable String secureVipAddress, @Nullable List<String> regions) {
        super(selectionStrategy, allowEmptyEndpoints, selectionTimeoutMillis);
        this.webClient = webClient;
        this.registryFetchIntervalMillis = registryFetchIntervalMillis;
        RequestHeadersBuilder headersBuilder = RequestHeaders.builder();
        headersBuilder.method(HttpMethod.GET);
        headersBuilder.accept(new MediaType[]{MediaType.JSON_UTF_8});
        this.responseConverter = EurekaEndpointGroup.responseConverter(headersBuilder, appName, instanceId, vipAddress, secureVipAddress, regions);
        this.requestHeaders = headersBuilder.build();
        webClient.options().factory().whenClosed().thenRun(() -> ((EurekaEndpointGroup)this).closeAsync());
        this.fetchRegistry();
    }

    private void fetchRegistry() {
        if (this.closed) {
            return;
        }
        try {
            ClientRequestContext ctx;
            HttpResponse response;
            try (ClientRequestContextCaptor captor = Clients.newContextCaptor();){
                response = this.webClient.execute(this.requestHeaders);
                ctx = captor.get();
            }
            EventLoop eventLoop = ctx.eventLoop().withoutContext();
            response.aggregate(AggregationOptions.usePooledObjects((ByteBufAllocator)ctx.alloc(), (EventExecutor)eventLoop)).handle((aggregatedRes, cause) -> {
                if (this.closed) {
                    if (aggregatedRes != null) {
                        aggregatedRes.content().close();
                    }
                    return null;
                }
                if (cause != null) {
                    logger.warn("Unexpected exception while fetching the registry from: {}. (requestHeaders: {})", new Object[]{this.webClient.uri(), this.requestHeaders, cause});
                } else {
                    try (HttpData content = aggregatedRes.content();){
                        HttpStatus status = aggregatedRes.status();
                        if (!status.isSuccess()) {
                            logger.warn("Unexpected response from: {}. (status: {}, content: {}, requestHeaders: {})", new Object[]{this.webClient.uri(), status, aggregatedRes.contentUtf8(), this.requestHeaders});
                        } else {
                            try {
                                List<Endpoint> endpoints = this.responseConverter.apply(content.array());
                                this.setEndpoints(endpoints);
                            }
                            catch (Exception e) {
                                logger.warn("Unexpected exception while parsing a response from: {}. (content: {}, responseConverter: {}, requestHeaders: {})", new Object[]{this.webClient.uri(), content.toStringUtf8(), this.responseConverter, this.requestHeaders, e});
                            }
                        }
                    }
                }
                this.scheduleNextFetch(eventLoop);
                return null;
            });
        }
        catch (Exception e) {
            logger.warn("Unexpected exception while fetching the registry from: {}. (requestHeaders: {})", new Object[]{this.webClient.uri(), this.requestHeaders, e});
            this.scheduleNextFetch(CommonPools.workerGroup().next());
        }
    }

    private void scheduleNextFetch(EventLoop executorService) {
        this.scheduledFuture = executorService.schedule(this::fetchRegistry, this.registryFetchIntervalMillis, TimeUnit.MILLISECONDS);
    }

    @Nullable
    @VisibleForTesting
    ScheduledFuture<?> scheduledFuture() {
        return this.scheduledFuture;
    }

    protected void doCloseAsync(CompletableFuture<?> future) {
        this.closed = true;
        ScheduledFuture<?> scheduledFuture = this.scheduledFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
        }
        super.doCloseAsync(future);
    }

    private static Function<byte[], List<Endpoint>> responseConverter(RequestHeadersBuilder builder, @Nullable String appName, @Nullable String instanceId, @Nullable String vipAddress, @Nullable String secureVipAddress, @Nullable List<String> regions) {
        if (regions != null) {
            Predicate<InstanceInfo> filter;
            String path;
            boolean secureVip = false;
            if (vipAddress != null) {
                path = VIPS + vipAddress;
                filter = instanceInfo -> vipAddress.equals(instanceInfo.getVipAddress());
            } else if (secureVipAddress != null) {
                secureVip = true;
                path = SVIPS + secureVipAddress;
                filter = instanceInfo -> secureVipAddress.equals(instanceInfo.getSecureVipAddress());
            } else {
                path = APPS;
                filter = appName == null && instanceId == null ? allInstances : (appName != null && instanceId != null ? instanceInfo -> appName.equals(instanceInfo.getAppName()) && instanceId.equals(instanceInfo.getInstanceId()) : (appName != null ? instanceInfo -> appName.equals(instanceInfo.getAppName()) : instanceInfo -> instanceId.equals(instanceInfo.getInstanceId())));
            }
            StringJoiner joiner = new StringJoiner(",");
            regions.forEach(joiner::add);
            QueryParams queryParams = QueryParams.of((String)"regions", (String)joiner.toString());
            builder.path(path + '?' + queryParams.toQueryString());
            return new ApplicationsConverter(filter, secureVip);
        }
        if (vipAddress != null) {
            builder.path(VIPS + vipAddress);
            return new ApplicationsConverter();
        }
        if (secureVipAddress != null) {
            builder.path(SVIPS + secureVipAddress);
            return new ApplicationsConverter(allInstances, true);
        }
        if (appName == null && instanceId == null) {
            builder.path(APPS);
            return new ApplicationsConverter();
        }
        if (appName != null && instanceId != null) {
            builder.path("/apps/" + appName + '/' + instanceId);
            return new InstanceInfoConverter();
        }
        if (appName != null) {
            builder.path("/apps/" + appName);
            return new ApplicationConverter();
        }
        builder.path(INSTANCES + instanceId);
        return new InstanceInfoConverter();
    }

    private static List<Endpoint> endpoints(Application application, Predicate<InstanceInfo> filter, boolean secureVip) {
        Set<InstanceInfo> instances = application.instances();
        return (List)instances.stream().filter(filter).filter(instanceInfo -> instanceInfo.getStatus() == InstanceInfo.InstanceStatus.UP).map(instanceInfo -> EurekaEndpointGroup.endpoint(instanceInfo, secureVip)).collect(ImmutableList.toImmutableList());
    }

    private static Endpoint endpoint(InstanceInfo instanceInfo, boolean secureVip) {
        String hostname = instanceInfo.getHostName();
        InstanceInfo.PortWrapper portWrapper = instanceInfo.getPort();
        int port = secureVip || !portWrapper.isEnabled() ? instanceInfo.getSecurePort().getPort() : portWrapper.getPort();
        assert (hostname != null);
        Endpoint endpoint = Endpoint.of((String)hostname, (int)port);
        String ipAddr = instanceInfo.getIpAddr();
        if (ipAddr != null && hostname != ipAddr) {
            endpoint = endpoint.withIpAddr(ipAddr);
        }
        return endpoint;
    }

    public String toString() {
        return this.toString(buf -> buf.append(", requestHeaders=").append(this.requestHeaders));
    }

    private static class ApplicationsConverter
    implements Function<byte[], List<Endpoint>> {
        private final Predicate<InstanceInfo> filter;
        private final boolean secureVip;

        ApplicationsConverter() {
            this(allInstances, false);
        }

        ApplicationsConverter(Predicate<InstanceInfo> filter, boolean secureVip) {
            this.filter = filter;
            this.secureVip = secureVip;
        }

        @Override
        public List<Endpoint> apply(byte[] content) {
            try {
                Set<Application> applications = ((Applications)mapper.readValue(content, Applications.class)).applications();
                return (List)applications.stream().map(application -> EurekaEndpointGroup.endpoints(application, this.filter, this.secureVip)).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class InstanceInfoConverter
    implements Function<byte[], List<Endpoint>> {
        private InstanceInfoConverter() {
        }

        @Override
        public List<Endpoint> apply(byte[] content) {
            try {
                return ImmutableList.of((Object)EurekaEndpointGroup.endpoint((InstanceInfo)mapper.readValue(content, InstanceInfo.class), false));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class ApplicationConverter
    implements Function<byte[], List<Endpoint>> {
        private final Predicate<InstanceInfo> filter;

        ApplicationConverter() {
            this(allInstances);
        }

        ApplicationConverter(Predicate<InstanceInfo> filter) {
            this.filter = filter;
        }

        @Override
        public List<Endpoint> apply(byte[] content) {
            try {
                Application application = (Application)mapper.readValue(content, Application.class);
                return EurekaEndpointGroup.endpoints(application, this.filter, false);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

