/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.eureka;

import com.linecorp.armeria.client.AbstractWebClientBuilder;
import com.linecorp.armeria.client.ClientBuilderParams;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientOption;
import com.linecorp.armeria.client.ClientOptionValue;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.DecoratingHttpClientFunction;
import com.linecorp.armeria.client.DecoratingRpcClientFunction;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.ResponseTimeoutMode;
import com.linecorp.armeria.client.RpcClient;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.client.endpoint.AbstractDynamicEndpointGroupBuilder;
import com.linecorp.armeria.client.endpoint.DynamicEndpointGroupSetters;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.endpoint.EndpointSelectionStrategy;
import com.linecorp.armeria.client.eureka.EurekaEndpointGroup;
import com.linecorp.armeria.client.redirect.RedirectConfig;
import com.linecorp.armeria.client.retry.RetryingClient;
import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.RequestId;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.SuccessFunction;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.auth.AuthToken;
import com.linecorp.armeria.common.auth.BasicToken;
import com.linecorp.armeria.common.auth.OAuth1aToken;
import com.linecorp.armeria.common.auth.OAuth2Token;
import com.linecorp.armeria.internal.common.eureka.EurekaClientUtil;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class EurekaEndpointGroupBuilder
extends AbstractWebClientBuilder
implements DynamicEndpointGroupSetters<EurekaEndpointGroupBuilder> {
    private static final long DEFAULT_REGISTRY_FETCH_INTERVAL_MILLIS = 30000L;
    private final DynamicEndpointGroupBuilder dynamicEndpointGroupBuilder = new DynamicEndpointGroupBuilder();
    private EndpointSelectionStrategy selectionStrategy = EndpointSelectionStrategy.weightedRoundRobin();
    @Nullable
    private String appName;
    @Nullable
    private String instanceId;
    @Nullable
    private String vipAddress;
    @Nullable
    private String secureVipAddress;
    private long registryFetchIntervalMillis = 30000L;
    @Nullable
    private List<String> regions;

    EurekaEndpointGroupBuilder(URI eurekaUri) {
        super(Objects.requireNonNull(eurekaUri, "eurekaUri"));
    }

    EurekaEndpointGroupBuilder(SessionProtocol sessionProtocol, EndpointGroup endpointGroup, @Nullable String path) {
        super(sessionProtocol, endpointGroup, path);
    }

    public EurekaEndpointGroupBuilder selectionStrategy(EndpointSelectionStrategy selectionStrategy) {
        this.selectionStrategy = Objects.requireNonNull(selectionStrategy, "selectionStrategy");
        return this;
    }

    public EurekaEndpointGroupBuilder regions(String ... regions) {
        return this.regions((Iterable<String>)ImmutableList.copyOf((Object[])Objects.requireNonNull(regions, "regions")));
    }

    public EurekaEndpointGroupBuilder regions(Iterable<String> regions) {
        this.regions = ImmutableList.copyOf(Objects.requireNonNull(regions, "regions"));
        return this;
    }

    public EurekaEndpointGroupBuilder appName(String appName) {
        Objects.requireNonNull(appName, "appName");
        Preconditions.checkArgument((!appName.isEmpty() ? 1 : 0) != 0, (Object)"appName is empty.");
        Preconditions.checkState((this.vipAddress == null && this.secureVipAddress == null ? 1 : 0) != 0, (String)"cannot set appName with the %s.", (Object)(this.vipAddress != null ? "vipAddress" : "secureVipAddress"));
        this.appName = appName;
        return this;
    }

    public EurekaEndpointGroupBuilder instanceId(String instanceId) {
        Objects.requireNonNull(instanceId, "instanceId");
        Preconditions.checkArgument((!instanceId.isEmpty() ? 1 : 0) != 0, (Object)"instanceId is empty.");
        Preconditions.checkState((this.vipAddress == null && this.secureVipAddress == null ? 1 : 0) != 0, (String)"cannot set instanceId with the %s.", (Object)(this.vipAddress != null ? "vipAddress" : "secureVipAddress"));
        this.instanceId = instanceId;
        return this;
    }

    public EurekaEndpointGroupBuilder vipAddress(String vipAddress) {
        Objects.requireNonNull(vipAddress, "vipAddress");
        Preconditions.checkArgument((!vipAddress.isEmpty() ? 1 : 0) != 0, (Object)"vipAddress is empty.");
        Preconditions.checkState((this.appName == null && this.instanceId == null && this.secureVipAddress == null ? 1 : 0) != 0, (String)"cannot set vipAddress with the %s.", (Object)(this.secureVipAddress != null ? "secureVipAddress" : "appName or instanceId"));
        this.vipAddress = vipAddress;
        return this;
    }

    public EurekaEndpointGroupBuilder secureVipAddress(String secureVipAddress) {
        Objects.requireNonNull(secureVipAddress, "secureVipAddress");
        Preconditions.checkArgument((!secureVipAddress.isEmpty() ? 1 : 0) != 0, (Object)"secureVipAddress is empty.");
        Preconditions.checkState((this.appName == null && this.instanceId == null && this.vipAddress == null ? 1 : 0) != 0, (String)"cannot set secureVipAddress with the %s.", (Object)(this.vipAddress != null ? "vipAddress" : "appName or instanceId"));
        this.secureVipAddress = secureVipAddress;
        return this;
    }

    public EurekaEndpointGroupBuilder registryFetchInterval(Duration registryFetchInterval) {
        Objects.requireNonNull(registryFetchInterval, "registryFetchInterval");
        Preconditions.checkArgument((!registryFetchInterval.isZero() && !registryFetchInterval.isNegative() ? 1 : 0) != 0, (String)"registryFetchInterval: %s (expected: > 0)", (Object)registryFetchInterval);
        return this.registryFetchIntervalMillis(registryFetchInterval.toMillis());
    }

    @Deprecated
    public EurekaEndpointGroupBuilder registryFetchIntervalSeconds(long registryFetchIntervalSeconds) {
        Preconditions.checkArgument((registryFetchIntervalSeconds > 0L ? 1 : 0) != 0, (String)"registryFetchIntervalSeconds: %s (expected: > 0)", (long)registryFetchIntervalSeconds);
        return this.registryFetchIntervalMillis(TimeUnit.SECONDS.toMillis(registryFetchIntervalSeconds));
    }

    public EurekaEndpointGroupBuilder registryFetchIntervalMillis(long registryFetchIntervalMillis) {
        Preconditions.checkArgument((registryFetchIntervalMillis > 0L ? 1 : 0) != 0, (String)"registryFetchIntervalMillis: %s (expected: > 0)", (long)registryFetchIntervalMillis);
        this.registryFetchIntervalMillis = registryFetchIntervalMillis;
        return this;
    }

    public EurekaEndpointGroup build() {
        WebClient client;
        WebClient webClient = this.buildWebClient();
        if (webClient.as(RetryingClient.class) != null) {
            client = webClient;
        } else {
            ClientOptions options = this.buildOptions(EurekaClientUtil.retryingClientOptions());
            ClientBuilderParams params = this.clientBuilderParams(options);
            ClientFactory factory = options.factory();
            client = (WebClient)factory.newClient(params);
        }
        boolean allowEmptyEndpoints = this.dynamicEndpointGroupBuilder.shouldAllowEmptyEndpoints();
        long selectionTimeoutMillis = this.dynamicEndpointGroupBuilder.selectionTimeoutMillis();
        return new EurekaEndpointGroup(this.selectionStrategy, allowEmptyEndpoints, selectionTimeoutMillis, client, this.registryFetchIntervalMillis, this.appName, this.instanceId, this.vipAddress, this.secureVipAddress, this.regions);
    }

    public EurekaEndpointGroupBuilder options(ClientOptions options) {
        return (EurekaEndpointGroupBuilder)super.options(options);
    }

    public EurekaEndpointGroupBuilder options(ClientOptionValue<?> ... options) {
        return (EurekaEndpointGroupBuilder)super.options(options);
    }

    public EurekaEndpointGroupBuilder options(Iterable<ClientOptionValue<?>> options) {
        return (EurekaEndpointGroupBuilder)super.options(options);
    }

    public <T> EurekaEndpointGroupBuilder option(ClientOption<T> option, T value) {
        return (EurekaEndpointGroupBuilder)super.option(option, value);
    }

    public <T> EurekaEndpointGroupBuilder option(ClientOptionValue<T> optionValue) {
        return (EurekaEndpointGroupBuilder)super.option(optionValue);
    }

    public EurekaEndpointGroupBuilder factory(ClientFactory factory) {
        return (EurekaEndpointGroupBuilder)super.factory(factory);
    }

    public EurekaEndpointGroupBuilder writeTimeout(Duration writeTimeout) {
        return (EurekaEndpointGroupBuilder)super.writeTimeout(writeTimeout);
    }

    public EurekaEndpointGroupBuilder writeTimeoutMillis(long writeTimeoutMillis) {
        return (EurekaEndpointGroupBuilder)super.writeTimeoutMillis(writeTimeoutMillis);
    }

    public EurekaEndpointGroupBuilder responseTimeout(Duration responseTimeout) {
        return (EurekaEndpointGroupBuilder)super.responseTimeout(responseTimeout);
    }

    public EurekaEndpointGroupBuilder responseTimeoutMillis(long responseTimeoutMillis) {
        return (EurekaEndpointGroupBuilder)super.responseTimeoutMillis(responseTimeoutMillis);
    }

    public EurekaEndpointGroupBuilder maxResponseLength(long maxResponseLength) {
        return (EurekaEndpointGroupBuilder)super.maxResponseLength(maxResponseLength);
    }

    public EurekaEndpointGroupBuilder requestAutoAbortDelay(Duration delay) {
        return (EurekaEndpointGroupBuilder)super.requestAutoAbortDelay(delay);
    }

    public EurekaEndpointGroupBuilder requestAutoAbortDelayMillis(long delayMillis) {
        return (EurekaEndpointGroupBuilder)super.requestAutoAbortDelayMillis(delayMillis);
    }

    public EurekaEndpointGroupBuilder requestIdGenerator(Supplier<RequestId> requestIdGenerator) {
        return (EurekaEndpointGroupBuilder)super.requestIdGenerator(requestIdGenerator);
    }

    public EurekaEndpointGroupBuilder successFunction(SuccessFunction successFunction) {
        return (EurekaEndpointGroupBuilder)super.successFunction(successFunction);
    }

    public EurekaEndpointGroupBuilder endpointRemapper(Function<? super Endpoint, ? extends EndpointGroup> endpointRemapper) {
        return (EurekaEndpointGroupBuilder)super.endpointRemapper(endpointRemapper);
    }

    public EurekaEndpointGroupBuilder decorator(Function<? super HttpClient, ? extends HttpClient> decorator) {
        return (EurekaEndpointGroupBuilder)super.decorator(decorator);
    }

    public EurekaEndpointGroupBuilder decorator(DecoratingHttpClientFunction decorator) {
        return (EurekaEndpointGroupBuilder)super.decorator(decorator);
    }

    public EurekaEndpointGroupBuilder rpcDecorator(Function<? super RpcClient, ? extends RpcClient> decorator) {
        return (EurekaEndpointGroupBuilder)super.rpcDecorator(decorator);
    }

    public EurekaEndpointGroupBuilder rpcDecorator(DecoratingRpcClientFunction decorator) {
        return (EurekaEndpointGroupBuilder)super.rpcDecorator(decorator);
    }

    public EurekaEndpointGroupBuilder clearDecorators() {
        return (EurekaEndpointGroupBuilder)super.clearDecorators();
    }

    public EurekaEndpointGroupBuilder addHeader(CharSequence name, Object value) {
        return (EurekaEndpointGroupBuilder)super.addHeader(name, value);
    }

    public EurekaEndpointGroupBuilder addHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> headers) {
        return (EurekaEndpointGroupBuilder)super.addHeaders(headers);
    }

    public EurekaEndpointGroupBuilder setHeader(CharSequence name, Object value) {
        return (EurekaEndpointGroupBuilder)super.setHeader(name, value);
    }

    public EurekaEndpointGroupBuilder setHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> headers) {
        return (EurekaEndpointGroupBuilder)super.setHeaders(headers);
    }

    public EurekaEndpointGroupBuilder auth(BasicToken token) {
        return (EurekaEndpointGroupBuilder)super.auth(token);
    }

    public EurekaEndpointGroupBuilder auth(OAuth1aToken token) {
        return (EurekaEndpointGroupBuilder)super.auth(token);
    }

    public EurekaEndpointGroupBuilder auth(OAuth2Token token) {
        return (EurekaEndpointGroupBuilder)super.auth(token);
    }

    public EurekaEndpointGroupBuilder auth(AuthToken token) {
        return (EurekaEndpointGroupBuilder)super.auth(token);
    }

    public EurekaEndpointGroupBuilder followRedirects() {
        return (EurekaEndpointGroupBuilder)super.followRedirects();
    }

    public EurekaEndpointGroupBuilder followRedirects(RedirectConfig redirectConfig) {
        return (EurekaEndpointGroupBuilder)super.followRedirects(redirectConfig);
    }

    public EurekaEndpointGroupBuilder contextCustomizer(Consumer<? super ClientRequestContext> contextCustomizer) {
        return (EurekaEndpointGroupBuilder)super.contextCustomizer(contextCustomizer);
    }

    public EurekaEndpointGroupBuilder responseTimeoutMode(ResponseTimeoutMode responseTimeoutMode) {
        return (EurekaEndpointGroupBuilder)super.responseTimeoutMode(responseTimeoutMode);
    }

    public EurekaEndpointGroupBuilder allowEmptyEndpoints(boolean allowEmptyEndpoints) {
        this.dynamicEndpointGroupBuilder.allowEmptyEndpoints(allowEmptyEndpoints);
        return this;
    }

    public EurekaEndpointGroupBuilder selectionTimeout(Duration selectionTimeout) {
        this.dynamicEndpointGroupBuilder.selectionTimeout(selectionTimeout);
        return this;
    }

    public EurekaEndpointGroupBuilder selectionTimeoutMillis(long selectionTimeoutMillis) {
        this.dynamicEndpointGroupBuilder.selectionTimeoutMillis(selectionTimeoutMillis);
        return this;
    }

    private static class DynamicEndpointGroupBuilder
    extends AbstractDynamicEndpointGroupBuilder<DynamicEndpointGroupBuilder> {
        DynamicEndpointGroupBuilder() {
            super(Flags.defaultResponseTimeoutMillis());
        }

        public boolean shouldAllowEmptyEndpoints() {
            return super.shouldAllowEmptyEndpoints();
        }

        public long selectionTimeoutMillis() {
            return super.selectionTimeoutMillis();
        }
    }
}

