/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.eureka;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Objects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;

@JsonRootName(value="leaseInfo")
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public final class LeaseInfo {
    private final int renewalIntervalInSecs;
    private final int durationInSecs;
    private final long registrationTimestamp;
    private final long lastRenewalTimestamp;
    private final long evictionTimestamp;
    private final long serviceUpTimestamp;

    public LeaseInfo(int renewalIntervalInSecs, int durationInSecs) {
        this(renewalIntervalInSecs, durationInSecs, 0L, 0L, 0L, 0L);
    }

    public LeaseInfo(@JsonProperty(value="renewalIntervalInSecs") int renewalIntervalInSecs, @JsonProperty(value="durationInSecs") int durationInSecs, @JsonProperty(value="registrationTimestamp") long registrationTimestamp, @JsonProperty(value="lastRenewalTimestamp") long lastRenewalTimestamp, @JsonProperty(value="evictionTimestamp") long evictionTimestamp, @JsonProperty(value="serviceUpTimestamp") long serviceUpTimestamp) {
        Preconditions.checkArgument((renewalIntervalInSecs > 0 ? 1 : 0) != 0, (String)"renewalIntervalInSecs: %s (expected: > 0)", (int)renewalIntervalInSecs);
        Preconditions.checkArgument((durationInSecs > 0 ? 1 : 0) != 0, (String)"durationInSecs: %s (expected: > 0)", (int)durationInSecs);
        Preconditions.checkArgument((registrationTimestamp >= 0L ? 1 : 0) != 0, (String)"registrationTimestamp: %s (expected: >= 0)", (long)registrationTimestamp);
        Preconditions.checkArgument((lastRenewalTimestamp >= 0L ? 1 : 0) != 0, (String)"lastRenewalTimestamp: %s (expected: >= 0)", (long)lastRenewalTimestamp);
        Preconditions.checkArgument((evictionTimestamp >= 0L ? 1 : 0) != 0, (String)"evictionTimestamp: %s (expected: >= 0)", (long)evictionTimestamp);
        Preconditions.checkArgument((serviceUpTimestamp >= 0L ? 1 : 0) != 0, (String)"serviceUpTimestamp: %s (expected: >= 0)", (long)serviceUpTimestamp);
        this.renewalIntervalInSecs = renewalIntervalInSecs;
        this.durationInSecs = durationInSecs;
        this.registrationTimestamp = registrationTimestamp;
        this.lastRenewalTimestamp = lastRenewalTimestamp;
        this.evictionTimestamp = evictionTimestamp;
        this.serviceUpTimestamp = serviceUpTimestamp;
    }

    @JsonProperty
    public int getRenewalIntervalInSecs() {
        return this.renewalIntervalInSecs;
    }

    @JsonProperty
    public int getDurationInSecs() {
        return this.durationInSecs;
    }

    @JsonProperty
    public long getRegistrationTimestamp() {
        return this.registrationTimestamp;
    }

    @JsonProperty
    public long getLastRenewalTimestamp() {
        return this.lastRenewalTimestamp;
    }

    @JsonProperty
    public long getEvictionTimestamp() {
        return this.evictionTimestamp;
    }

    @JsonProperty
    public long getServiceUpTimestamp() {
        return this.serviceUpTimestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LeaseInfo)) {
            return false;
        }
        LeaseInfo leaseInfo = (LeaseInfo)o;
        return this.renewalIntervalInSecs == leaseInfo.renewalIntervalInSecs && this.durationInSecs == leaseInfo.durationInSecs && this.registrationTimestamp == leaseInfo.registrationTimestamp && this.lastRenewalTimestamp == leaseInfo.lastRenewalTimestamp && this.evictionTimestamp == leaseInfo.evictionTimestamp && this.serviceUpTimestamp == leaseInfo.serviceUpTimestamp;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.renewalIntervalInSecs, this.durationInSecs, this.registrationTimestamp, this.lastRenewalTimestamp, this.evictionTimestamp, this.serviceUpTimestamp});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("renewalIntervalInSecs", this.renewalIntervalInSecs).add("durationInSecs", this.durationInSecs).add("registrationTimestamp", this.registrationTimestamp).add("lastRenewalTimestamp", this.lastRenewalTimestamp).add("evictionTimestamp", this.evictionTimestamp).add("serviceUpTimestamp", this.serviceUpTimestamp).toString();
    }
}

