/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.eureka;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.linecorp.armeria.internal.common.eureka.Application;
import com.linecorp.armeria.internal.common.eureka.Applications;
import java.io.IOException;
import java.util.HashSet;

final class ApplicationsDeserializer
extends StdDeserializer<Applications> {
    private static final long serialVersionUID = -2925089225769559114L;
    private static final String APPS_HASHCODE = "apps_hashcode";
    private static final String APPLICATION = "application";
    private static final ObjectReader readerForApplication = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).readerFor(Application.class);

    ApplicationsDeserializer() {
        super(Applications.class);
    }

    public Applications deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken jsonToken;
        String appsHashCode = null;
        HashSet<Application> applications = new HashSet<Application>();
        while ((jsonToken = p.nextToken()) != JsonToken.END_OBJECT) {
            if (JsonToken.FIELD_NAME != jsonToken) continue;
            String fieldName = p.getCurrentName();
            jsonToken = p.nextToken();
            if (APPS_HASHCODE.equals(fieldName)) {
                appsHashCode = p.getValueAsString();
                continue;
            }
            if (!APPLICATION.equals(fieldName)) continue;
            if (jsonToken == JsonToken.START_ARRAY) {
                while (p.nextToken() != JsonToken.END_ARRAY) {
                    applications.add((Application)readerForApplication.readValue(p));
                }
                continue;
            }
            if (jsonToken != JsonToken.START_OBJECT) continue;
            applications.add((Application)readerForApplication.readValue(p));
        }
        return new Applications(appsHashCode, applications);
    }
}

