/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.graphql;

import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.graphql.protocol.GraphqlRequest;
import com.linecorp.armeria.internal.server.graphql.protocol.GraphqlUtil;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.graphql.GraphqlService;
import com.linecorp.armeria.server.graphql.GraphqlServiceContexts;
import com.linecorp.armeria.server.graphql.protocol.AbstractGraphqlService;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQL;
import graphql.GraphQLError;
import graphql.GraphqlErrorException;
import graphql.validation.ValidationError;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.dataloader.DataLoaderRegistry;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultGraphqlService
extends AbstractGraphqlService
implements GraphqlService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultGraphqlService.class);
    private final GraphQL graphQL;
    private final DataLoaderRegistry dataLoaderRegistry;
    private final boolean useBlockingTaskExecutor;

    DefaultGraphqlService(GraphQL graphQL, DataLoaderRegistry dataLoaderRegistry, boolean useBlockingTaskExecutor) {
        this.graphQL = Objects.requireNonNull(graphQL, "graphQL");
        this.dataLoaderRegistry = Objects.requireNonNull(dataLoaderRegistry, "dataLoaderRegistry");
        this.useBlockingTaskExecutor = useBlockingTaskExecutor;
    }

    protected HttpResponse executeGraphql(ServiceRequestContext ctx, GraphqlRequest req) throws Exception {
        String operationName;
        Map extensions;
        MediaType produceType = GraphqlUtil.produceType((RequestHeaders)ctx.request().headers());
        if (produceType == null) {
            return HttpResponse.of((HttpStatus)HttpStatus.NOT_ACCEPTABLE, (MediaType)MediaType.PLAIN_TEXT, (String)"Only application/graphql+json and application/json compatible media types are acceptable");
        }
        ExecutionInput.Builder builder = ExecutionInput.newExecutionInput((String)req.query());
        Map variables = req.variables();
        if (!variables.isEmpty()) {
            builder.variables(variables);
        }
        if (!(extensions = req.extensions()).isEmpty()) {
            builder.extensions(extensions);
        }
        if ((operationName = req.operationName()) != null) {
            builder.operationName(operationName);
        }
        ExecutionInput executionInput = builder.context((Object)ctx).graphQLContext(GraphqlServiceContexts.graphqlContext(ctx)).dataLoaderRegistry(this.dataLoaderRegistry).build();
        return this.execute(ctx, executionInput, produceType);
    }

    private HttpResponse execute(ServiceRequestContext ctx, ExecutionInput input, MediaType produceType) {
        CompletableFuture<ExecutionResult> future = this.useBlockingTaskExecutor ? CompletableFuture.supplyAsync(() -> this.graphQL.execute(input), (Executor)ctx.blockingTaskExecutor()) : this.graphQL.executeAsync(input);
        return HttpResponse.from((CompletionStage)future.handle((executionResult, cause) -> {
            if (cause != null) {
                ExecutionResult error = DefaultGraphqlService.newExecutionResult(cause);
                return HttpResponse.ofJson((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR, (MediaType)produceType, (Object)error.toSpecification());
            }
            List errors = executionResult.getErrors();
            if (!errors.isEmpty()) {
                if (errors.stream().anyMatch(ValidationError.class::isInstance)) {
                    return HttpResponse.ofJson((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)produceType, (Object)executionResult.toSpecification());
                }
            }
            return DefaultGraphqlService.toHttpResponse(executionResult, produceType);
        }));
    }

    private static HttpResponse toHttpResponse(ExecutionResult executionResult, MediaType produceType) {
        if (executionResult.getData() instanceof Publisher) {
            logger.warn("executionResult.getData() returns a {} that is not supported yet.", (Object)executionResult.getData().toString());
            ExecutionResult error = DefaultGraphqlService.newExecutionResult(new UnsupportedOperationException("WebSocket is not implemented"));
            return HttpResponse.ofJson((HttpStatus)HttpStatus.NOT_IMPLEMENTED, (MediaType)produceType, (Object)error.toSpecification());
        }
        return HttpResponse.ofJson((MediaType)produceType, (Object)executionResult.toSpecification());
    }

    private static ExecutionResult newExecutionResult(Throwable cause) {
        return new ExecutionResultImpl((GraphQLError)((GraphqlErrorException.Builder)((GraphqlErrorException.Builder)GraphqlErrorException.newErrorException().message(cause.getMessage())).cause(cause)).build());
    }
}

