/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.graphql;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.util.ResourceUtil;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.Streams;
import com.linecorp.armeria.server.graphql.DefaultGraphqlService;
import com.linecorp.armeria.server.graphql.GraphqlConfigurator;
import com.linecorp.armeria.server.graphql.GraphqlService;
import com.linecorp.armeria.server.graphql.RuntimeWiringConfigurator;
import graphql.GraphQL;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.instrumentation.Instrumentation;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.SchemaTransformer;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.dataloader.DataLoaderRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GraphqlServiceBuilder {
    private static final Logger logger = LoggerFactory.getLogger(GraphqlServiceBuilder.class);
    private static final List<String> DEFAULT_SCHEMA_FILE_NAMES = ImmutableList.of((Object)"schema.graphqls", (Object)"schema.graphql");
    private final ImmutableList.Builder<URL> schemaUrls = ImmutableList.builder();
    private final ImmutableList.Builder<RuntimeWiringConfigurator> runtimeWiringConfigurators = ImmutableList.builder();
    private final ImmutableList.Builder<Consumer<? super DataLoaderRegistry>> dataLoaderRegistryConsumers = ImmutableList.builder();
    private final ImmutableList.Builder<GraphQLTypeVisitor> typeVisitors = ImmutableList.builder();
    private final ImmutableList.Builder<Instrumentation> instrumentations = ImmutableList.builder();
    private final ImmutableList.Builder<GraphqlConfigurator> graphqlBuilderConsumers = ImmutableList.builder();
    private boolean useBlockingTaskExecutor;
    @Nullable
    private GraphQLSchema schema;

    GraphqlServiceBuilder() {
    }

    public GraphqlServiceBuilder schemaFile(File ... schemaFiles) {
        return this.schemaFile((Iterable<? extends File>)ImmutableList.copyOf((Object[])Objects.requireNonNull(schemaFiles, "schemaFiles")));
    }

    public GraphqlServiceBuilder schemaFile(Iterable<? extends File> schemaFiles) {
        Objects.requireNonNull(schemaFiles, "schemaFiles");
        return this.schemaUrls0((Iterable)Streams.stream(schemaFiles).map(file -> {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new UncheckedIOException(e);
            }
        }).collect(ImmutableList.toImmutableList()));
    }

    public GraphqlServiceBuilder schemaUrls(String ... schemaUrls) {
        return this.schemaUrls((Iterable<String>)ImmutableList.copyOf((Object[])Objects.requireNonNull(schemaUrls, "schemaUrls")));
    }

    public GraphqlServiceBuilder schemaUrls(Iterable<String> schemaUrls) {
        Objects.requireNonNull(schemaUrls, "schemaUrls");
        return this.schemaUrls0((Iterable)Streams.stream(schemaUrls).map(url -> {
            try {
                return ResourceUtil.getUrl((String)url);
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("Not found schema file(s)", e);
            }
        }).collect(ImmutableList.toImmutableList()));
    }

    private GraphqlServiceBuilder schemaUrls0(Iterable<URL> schemaUrls) {
        this.schemaUrls.addAll(Objects.requireNonNull(schemaUrls, "schemaUrls"));
        return this;
    }

    public GraphqlServiceBuilder schema(GraphQLSchema schema) {
        this.schema = Objects.requireNonNull(schema, "schema");
        return this;
    }

    public GraphqlServiceBuilder configureDataLoaderRegistry(Consumer<DataLoaderRegistry> ... configurers) {
        Objects.requireNonNull(configurers, "configurers");
        return this.configureDataLoaderRegistry((Iterable<? extends Consumer<? super DataLoaderRegistry>>)ImmutableList.copyOf((Object[])configurers));
    }

    public GraphqlServiceBuilder configureDataLoaderRegistry(Iterable<? extends Consumer<? super DataLoaderRegistry>> configurers) {
        this.dataLoaderRegistryConsumers.addAll(Objects.requireNonNull(configurers, "configurers"));
        return this;
    }

    public GraphqlServiceBuilder runtimeWiring(RuntimeWiringConfigurator ... runtimeWiringConfigurators) {
        Objects.requireNonNull(runtimeWiringConfigurators, "runtimeWiringConfigurators");
        return this.runtimeWiring((Iterable<? extends RuntimeWiringConfigurator>)ImmutableList.copyOf((Object[])runtimeWiringConfigurators));
    }

    public GraphqlServiceBuilder runtimeWiring(Iterable<? extends RuntimeWiringConfigurator> configurators) {
        this.runtimeWiringConfigurators.addAll(Objects.requireNonNull(configurators, "configurators"));
        return this;
    }

    public GraphqlServiceBuilder typeVisitors(GraphQLTypeVisitor ... typeVisitors) {
        return this.typeVisitors((Iterable<? extends GraphQLTypeVisitor>)ImmutableList.copyOf((Object[])Objects.requireNonNull(typeVisitors, "typeVisitors")));
    }

    public GraphqlServiceBuilder typeVisitors(Iterable<? extends GraphQLTypeVisitor> typeVisitors) {
        this.typeVisitors.addAll(Objects.requireNonNull(typeVisitors, "typeVisitors"));
        return this;
    }

    public GraphqlServiceBuilder instrumentation(Instrumentation ... instrumentations) {
        Objects.requireNonNull(instrumentations, "instrumentations");
        return this.instrumentation((Iterable<? extends Instrumentation>)ImmutableList.copyOf((Object[])instrumentations));
    }

    public GraphqlServiceBuilder instrumentation(Iterable<? extends Instrumentation> instrumentations) {
        this.instrumentations.addAll(Objects.requireNonNull(instrumentations, "instrumentations"));
        return this;
    }

    public GraphqlServiceBuilder configureGraphql(GraphqlConfigurator ... configurers) {
        return this.configureGraphql((Iterable<? extends GraphqlConfigurator>)ImmutableList.copyOf((Object[])Objects.requireNonNull(configurers, "configurers")));
    }

    public GraphqlServiceBuilder configureGraphql(Iterable<? extends GraphqlConfigurator> configurers) {
        this.graphqlBuilderConsumers.addAll(Objects.requireNonNull(configurers, "configurers"));
        return this;
    }

    public GraphqlServiceBuilder useBlockingTaskExecutor(boolean useBlockingTaskExecutor) {
        this.useBlockingTaskExecutor = useBlockingTaskExecutor;
        return this;
    }

    public GraphqlService build() {
        GraphQLSchema schema = this.buildSchema();
        GraphQL.Builder builder = GraphQL.newGraphQL((GraphQLSchema)schema);
        ImmutableList instrumentations = this.instrumentations.build();
        if (!instrumentations.isEmpty()) {
            builder = builder.instrumentation((Instrumentation)new ChainedInstrumentation((List)instrumentations));
        }
        ImmutableList graphqlBuilders = this.graphqlBuilderConsumers.build();
        for (GraphqlConfigurator configurer : graphqlBuilders) {
            configurer.configure(builder);
        }
        DataLoaderRegistry dataLoaderRegistry = new DataLoaderRegistry();
        ImmutableList dataLoaderRegistries = this.dataLoaderRegistryConsumers.build();
        for (Consumer configurer : dataLoaderRegistries) {
            configurer.accept(dataLoaderRegistry);
        }
        return new DefaultGraphqlService(builder.build(), dataLoaderRegistry, this.useBlockingTaskExecutor);
    }

    private GraphQLSchema buildSchema() {
        ImmutableList schemaUrls = this.schemaUrls.build();
        ImmutableList runtimeWiringConfigurators = this.runtimeWiringConfigurators.build();
        ImmutableList typeVisitors = this.typeVisitors.build();
        if (this.schema != null) {
            Preconditions.checkState((schemaUrls.isEmpty() && runtimeWiringConfigurators.isEmpty() && typeVisitors.isEmpty() ? 1 : 0) != 0, (Object)"Cannot add schemaUrl(or File), runtimeWiringConfigurator and typeVisitor when GraphqlSchema is specified.");
            return this.schema;
        }
        TypeDefinitionRegistry registry = GraphqlServiceBuilder.typeDefinitionRegistry((List<URL>)schemaUrls);
        RuntimeWiring runtimeWiring = GraphqlServiceBuilder.buildRuntimeWiring((List<RuntimeWiringConfigurator>)runtimeWiringConfigurators);
        GraphQLSchema schema = new SchemaGenerator().makeExecutableSchema(registry, runtimeWiring);
        for (GraphQLTypeVisitor typeVisitor : typeVisitors) {
            schema = SchemaTransformer.transformSchema((GraphQLSchema)schema, (GraphQLTypeVisitor)typeVisitor);
        }
        return schema;
    }

    private static TypeDefinitionRegistry typeDefinitionRegistry(List<URL> schemaUrls) {
        TypeDefinitionRegistry registry = new TypeDefinitionRegistry();
        SchemaParser parser = new SchemaParser();
        if (schemaUrls.isEmpty()) {
            schemaUrls = GraphqlServiceBuilder.defaultSchemaUrls();
        }
        if (schemaUrls.isEmpty()) {
            throw new IllegalStateException("Not found schema file(s)");
        }
        logger.info("Found schema files: {}", schemaUrls);
        schemaUrls.forEach(url -> {
            try (InputStream inputStream = url.openStream();){
                registry.merge(parser.parse(inputStream));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        return registry;
    }

    private static RuntimeWiring buildRuntimeWiring(List<RuntimeWiringConfigurator> runtimeWiringConfigurators) {
        RuntimeWiring.Builder runtimeWiringBuilder = RuntimeWiring.newRuntimeWiring();
        runtimeWiringConfigurators.forEach(it -> it.configure(runtimeWiringBuilder));
        return runtimeWiringBuilder.build();
    }

    private static List<URL> defaultSchemaUrls() {
        ClassLoader classLoader = GraphqlServiceBuilder.class.getClassLoader();
        return (List)DEFAULT_SCHEMA_FILE_NAMES.stream().map(classLoader::getResource).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
    }
}

